/*
  Copyright (c) 2006  Nikolaj Hald Nielsen <nhnFreespirit@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef MAGNATUNETYPES_H
#define MAGNATUNETYPES_H


#include <tqdatetime.h>
#include <tqstring.h>
#include <tqvaluelist.h>



class MagnatuneArtist 
{

private:
    int m_id;
    TQString m_name;
    TQString m_genre;
    TQString m_description;
    TQString m_photoURL;
    TQString m_homeURL;

public:
    MagnatuneArtist();

    void setId( int id );
    int getId() const;

    void setName( TQString name );
    TQString getName() const;

    void setDescription( TQString description );
    TQString getDescription() const;

    void setPhotoURL( TQString photoURL );
    TQString getPhotoURL() const;
  
    void setHomeURL( TQString homeURL );
    TQString getHomeURL() const;
};


class MagnatuneAlbum 
{
private:
    int m_id;
    TQString m_name;
    TQString m_coverURL;
    TQDate m_launchDate;
    TQString m_albumCode;
    TQString m_mp3Genre;
    TQString m_magnatuneGenres;
    int m_artistId;

public:
    MagnatuneAlbum();

    void setId( int id );
    int getId() const;

    void setName( TQString name );
    TQString getName() const;

    void setCoverURL( TQString coverURL );
    TQString getCoverURL() const;

    void setLaunchDate( TQDate launchDate );
    TQDate getLaunchDate() const;

    void setAlbumCode( TQString albumCode );
    TQString getAlbumCode() const;

    void setMp3Genre( TQString mp3Genre );
    TQString getMp3Genre() const;

    void setMagnatuneGenres( TQString magnatuneGenres );
    TQString getMagnatuneGenres() const;

    void setArtistId( int artistId );
    int getArtistId() const;


};

class MagnatuneTrack 
{
private:
    int m_id;
    TQString m_name;
    int m_trackNumber;
    int m_duration;
    TQString m_hifiURL;
    TQString m_lofiURL;
    int m_albumId;
    int m_artistId;

public:
    MagnatuneTrack();

    void setId( int id );
    int getId() const;
 
    void setName( TQString name );
    TQString getName() const;

    void setTrackNumber( int trackNumber );
    int getTrackNumber() const;

    void setDuration( int duration );
    int getDuration() const;

    void setHifiURL( TQString hifiURL );
    TQString getHifiURL() const;

    void setLofiURL( TQString lofiURL );
    TQString getLofiURL() const;

    void setAlbumId( int albumId );
    int getAlbumId() const;

    void setArtistId( int artistId );
    int getArtistId() const;
};

typedef TQValueList<MagnatuneArtist> MagnatuneArtistList;
typedef TQValueList<MagnatuneAlbum> MagnatuneAlbumList;
typedef TQValueList<MagnatuneTrack> MagnatuneTrackList;

#endif
