/***************************************************************************
 * copyright            : (C) 2006 Ian Monroe <ian@monroe.nu>              *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contentfetcher.h"
#include "debug.h"
#include "hasher.h"

#include <tqbuffer.h>
#include <tqsocket.h>
#include <tqdatastream.h>
#include <tqhttp.h>

#include <kfilterdev.h>
#include <kmdcodec.h>

using namespace Daap;
int ContentFetcher::s_requestId = 10;

ContentFetcher::ContentFetcher( const TQString & hostname, TQ_UINT16 port, const TQString& password, TQObject * parent, const char * name )
 : TQHttp(hostname, port, parent, name)
 , m_hostname( hostname )
 , m_port( port )
 , m_selfDestruct( false )
{
    connect( this, TQ_SIGNAL( stateChanged( int ) ), this , TQ_SLOT( checkForErrors( int ) ) );
    TQCString pass = password.utf8();
    if( !password.isNull() )
    {
        m_authorize = "Basic " + KCodecs::base64Encode( "none:" + pass );
    }
}

ContentFetcher::~ContentFetcher()
{ }

TQDataStream&
ContentFetcher::results()
{
    TQBuffer* bytes = new TQBuffer( readAll() ); 
    TQIODevice* stream =  KFilterDev::device( bytes, "application/x-gzip", false );
    stream->open( IO_ReadOnly );
    TQDataStream* ds = new TQDataStream( stream );
    return *ds;
}

void
ContentFetcher::getDaap( const TQString & command, TQIODevice* musicFile /*= 0*/ )
{
    TQHttpRequestHeader header( "GET", command );
    char hash[33] = {0};
    GenerateHash(3, reinterpret_cast<const unsigned char*>(command.ascii()), 2, reinterpret_cast<unsigned char*>(hash), 0 /*s_requestId*/);

    if( !m_authorize.isEmpty() )
    {
        header.setValue( "Authorization", m_authorize );
    }

    header.setValue( "Host", m_hostname + TQString::number( m_port ) );
    header.setValue( "Client-DAAP-Request-ID", "0"/*TQString::number( s_requestId )*/ );
    header.setValue( "Client-DAAP-Access-Index", "2" );
    header.setValue( "Client-DAAP-Validation", hash );
    header.setValue( "Client-DAAP-Version", "3.0" );
    header.setValue( "User-Agent", "iTunes/4.6 (Windows; N)" );
    header.setValue( "Accept", "*/*" );
    header.setValue( "Accept-Encoding", "gzip" );

    request( header, 0, musicFile );
}

/**
 *  TQHttp enjoys forgetting to emit a requestFinished when there's an error
 *  This gets around that.
 */
void
ContentFetcher::checkForErrors( int /*state*/ )
{
    if( !m_selfDestruct && error() != 0 )
    {
        debug() << "there is an error? " << error() << " " << errorString() << endl;
        m_selfDestruct = true;
        emit httpError( errorString() );
    }
}


#include "contentfetcher.moc"

