//
// C++ Implementation:
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "k9common.h"
#include "k9menuedit.h"
#include "k9menueditor.h"
#include "k9menu.h"
#include "k9title.h"
#include "k9newdvd.h"
#include <tqwmatrix.h>
#include <tqlayout.h>
#include <tdefontdialog.h>
#include "k9menubutton.h"
#include <kurlrequester.h>
#include <kcolorbutton.h>
#include <tqcombobox.h>
#include <tdelocale.h>
#include <tqlabel.h>
#include <kiconloader.h>




k9MenuEdit::k9MenuEdit(TQWidget* parent, const char* name,TQCanvas *_canvas)
        : menuEdit(parent,name) {
    bAddText->setPixmap (SmallIcon("add"));
    m_noUpdate=false;
    m_canvas=_canvas;
    m_format=PAL;
    m_imageHeight=576;
    TQGridLayout *grid=new TQGridLayout(frame,1,1);
    m_menuEditor=new k9MenuEditor(*m_canvas,frame);
    grid->addWidget(m_menuEditor,0,0);
    m_canvas->resize(720,m_imageHeight);
    m_text=NULL;
    m_menuEditor->setMenu(this);
    connect(m_menuEditor,TQ_SIGNAL(itemSelected()),this,TQ_SLOT(itemSelected()));
    cbPosTitle->setEnabled(false);
}
void k9MenuEdit::updateTextPos(const TQPoint &_point) {
    emit updatePos(_point);
}

void k9MenuEdit::itemSelected() {
    bool unselect=true;
    m_noUpdate=true;
    m_canvas->update();
    urBackground->setURL("");
    if (m_menuEditor->getSelected()) {
        //     m_menuEditor->getSelected()->select(true);
        cbColor->setColor(m_menuEditor->getSelected()->getColor());
        leTitle->setText(m_menuEditor->getSelected()->getText());
        cbPosTitle->setEnabled(true);
        cbPosTitle->setCurrentItem(m_menuEditor->getSelected()->getTextPosition()-1);
        urBackground->setEnabled(true);
        m_canvas->update();
    } else if (m_menuEditor->getMoving()) {
        if (m_menuEditor->getMoving()->rtti()==TQCanvasItem::Rtti_Text) {
            m_text=(TQCanvasText*)m_menuEditor->getMoving();
            leTitle->setText(m_text->text());
            cbColor->setColor(m_text->color());
            cbPosTitle->setEnabled(false);
            urBackground->setEnabled(false);
        }
    } else {
        urBackground->setEnabled(true);
        cbPosTitle->setEnabled(false);
    }
    m_noUpdate=false;
}





k9MenuEdit::~k9MenuEdit() {}

/*$SPECIALIZATION$*/


void k9MenuEdit::bFontClick() {
    if (m_menuEditor->getSelected()) {
        k9MenuButton *b=m_menuEditor->getSelected();
        TQFont myFont(b->getFont());
        int result = TDEFontDialog::getFont( myFont );
        if ( result == TDEFontDialog::Accepted && m_menuEditor->getSelected() ) {
            TQPtrList <k9MenuButton> *l=m_menuEditor->getSelection();
            for (b=l->first();b;b=l->next()) {
                b->setFont(myFont);
            }
        }
    } else {
        if (m_text) {
            TQFont myFont(m_text->font());
            int result = TDEFontDialog::getFont( myFont );
            if ( result == TDEFontDialog::Accepted  )
                setFont(myFont);
        }

    }
}

void k9MenuEdit::urBackgroundSelected(const TQString &_fileName) {
    if ( m_menuEditor->getSelected() ) {
//If a button is selected, set the button image ...
        k9MenuButton *b=(k9MenuButton*)m_menuEditor->getSelected();
        TQImage img;
        img.load(_fileName);
        b->setImage(img);
    } else {
//...otherwise, set the menu background image
        TQImage img;
        img.load(_fileName);
        img=img.smoothScale(720,m_imageHeight,TQImage::ScaleMax);
        setBackgroundImage(img);
    }
}

void k9MenuEdit::cbColorChanged(const TQColor &_color) {
    if (m_noUpdate)
        return;
    if ( m_menuEditor->getSelected() ) {
        TQPtrList <k9MenuButton> *l=m_menuEditor->getSelection();
        for (k9MenuButton *b=l->first();b;b=l->next()) {
            b->setColor(_color);
        }
        //m_menuEditor->getSelected()->setColor(_color);
    } else {
        setColor(_color);
    }

}

void k9MenuEdit::cbPosTitleActivated(int _value) {
    if (m_noUpdate)
        return;
    if ( m_menuEditor->getSelected() ) {
        TQPtrList <k9MenuButton> *l=m_menuEditor->getSelection();
        for (k9MenuButton *b=l->first();b;b=l->next()) {
            b->setTextPosition((k9MenuButton::eTextPosition)(_value+1));
        }
    }
}

void k9MenuEdit::setBackgroundImage(const TQImage &_image) {
    m_background=_image;
    m_canvas->setBackgroundPixmap(TQPixmap(_image));
    emit backgroundImageChanged(_image);
}

void k9MenuEdit::leTitleChanged(const TQString &_value) {
    if (m_noUpdate)
        return;
    if ( m_menuEditor->getSelected() ) {
        TQPtrList <k9MenuButton> *l=m_menuEditor->getSelection();
        for (k9MenuButton *b=l->first();b;b=l->next()) {
            TQString c=_value;
            b->setText(c.replace("%n",TQString::number(b->getNum())));
        }
        //m_menuEditor->getSelected()->setText(_value);
    } else {
        setText(_value);
    }
}

#include "k9menuedit.moc"





void k9MenuEdit::setText(const TQString &_value) {
    if (m_text)
        m_text->setText(_value);
    m_canvas->update();
    emit textChanged(_value);
}

void k9MenuEdit::setFont(const TQFont &_value) {
    if (m_text)
        m_text->setFont(_value);
    m_canvas->update();
    emit textFontChanged(_value);
}

void k9MenuEdit::setColor(const TQColor &_value) {
    if (m_text)
        m_text->setColor(_value);
    m_canvas->update();
    emit textColorChanged(_value);
}

TQCanvasText* k9MenuEdit::getText() const {
    return m_text;
}


k9MenuEdit::eFormat k9MenuEdit::getFormat() const {
    return m_format;
}


void k9MenuEdit::setFormat(const eFormat& _value) {
    m_format = _value;
    if (_value==NTSC)
        m_imageHeight=480;
    else
        m_imageHeight=576;
    TQPixmap pix=m_canvas->backgroundPixmap();
    TQImage img=pix.convertToImage().smoothScale(720,m_imageHeight);
    m_canvas->resize(720,m_imageHeight);
    m_menuEditor->setMaximumSize(TQSize(724,m_imageHeight+4));
    m_canvas->setBackgroundPixmap(TQPixmap(img));
}


TQCanvas *k9MenuEdit::getCanvas()  {
    return m_canvas;
}


void k9MenuEdit::setCanvas(TQCanvas* _value) {
    m_canvas = _value;
    m_text=NULL;
    m_menuEditor->setCanvas(_value);
    m_canvas->resize(720,m_imageHeight);
    m_canvas->update();
    m_menuEditor->updateContents();
}

void k9MenuEdit::titleSelected(k9Title *_title) {
    disconnect (this,TQ_SIGNAL(startScriptChanged(const TQString&)),0,0);
    disconnect (this,TQ_SIGNAL(endScriptChanged(const TQString&)),0,0);
    cbEnd->setEnabled(true);
    m_menuEditor->clearSelection();
    lTitle->setText(i18n("Title %1 Menu").arg(_title->getNum()+1));
    setCanvas(_title->getMenu()->getCanvas());
    m_menuType=TITLEMENU;
    cbStart->clear();
    cbEnd->clear();
    m_startScripts.clear();
    m_endScripts.clear();


    cbStart->insertItem(i18n("Play Menu"));
    m_startScripts << "";
    cbStart->insertItem(i18n("Play Title"));
    m_startScripts << "if (g1==0) {g1=1; jump title 1 chapter 1;}";
    if (_title->getMenu()->getStartScript() !="")
        cbStart->setCurrentItem(cbStart->count()-1);
    connect (this,TQ_SIGNAL(startScriptChanged(const TQString&)),_title->getMenu(),TQ_SLOT(setStartScript(const TQString&)));

    cbEnd->insertItem(i18n("Play Root Menu"));
    m_endScripts << "g6=0; call vmgm menu;";
    cbEnd->insertItem(i18n("Play Title Menu"));
    m_endScripts << "call menu;";
    k9NewDVD *newDVD=(k9NewDVD*)_title->parent() ;
    k9NewDVDItems *items=newDVD->getTitles();
    for (k9Title *title=items->first();title;title=items->next()) {
        cbEnd->insertItem(i18n("Play Title %1").arg(title->getNum()+1));
        TQString script=TQString("g6=%1; call vmgm menu;" ).arg(title->getNum()+1);
        m_endScripts << script;
    }
    for (int i=0;i<m_endScripts.count();i++ ){
        if (_title->getMenu()->getEndScript()== *(m_endScripts.at(i)))
            cbEnd->setCurrentItem(i);
    }
    connect (this,TQ_SIGNAL(endScriptChanged(const TQString&)),_title->getMenu(),TQ_SLOT(setEndScript(const TQString&)));

}

void k9MenuEdit::rootSelected(k9NewDVD *_newDVD) {
    disconnect (this,TQ_SIGNAL(startScriptChanged(const TQString&)),0,0);
    disconnect (this,TQ_SIGNAL(endScriptChanged(const TQString&)),0,0);
    cbEnd->setEnabled(false);
    m_menuEditor->clearSelection();
    lTitle->setText(i18n("Root Menu"));
    setCanvas(_newDVD->getRootMenu()->getCanvas());
    m_menuType=ROOTMENU;
    cbStart->clear();
    m_startScripts.clear();
    cbStart->insertItem(i18n("Play Menu"));
    m_startScripts << "";
    k9NewDVDItems *items=_newDVD->getTitles();
    for (k9Title *title=items->first();title;title=items->next()) {
        cbStart->insertItem(i18n("Play Title %1").arg(title->getNum()+1));
       // TQString script=TQString("if (g5==0) {g5=1; jump title %1;}" ).arg(title->getNum()+1);
        TQString script=TQString("g6=%1;" ).arg(title->getNum()+1);
        m_startScripts << script;
        if (script==_newDVD->getRootMenu()->getStartScript())
            cbStart->setCurrentItem(cbStart->count()-1);
    }
    connect (this,TQ_SIGNAL(startScriptChanged(const TQString&)),_newDVD->getRootMenu(),TQ_SLOT(setStartScript(const TQString&)));
}

void k9MenuEdit::bAddTextClick() {
    m_text=new TQCanvasText(m_canvas);
    m_text->show();
    m_menuEditor->setMoving(m_text);
    setText(leTitle->text());
    setColor(cbColor->color());
}

void k9MenuEdit::cbStartActivated (int _value) {
    emit startScriptChanged(m_startScripts[_value]);
}

void k9MenuEdit::cbEndActivated (int _value) {
    emit endScriptChanged(m_endScripts[_value]);
}
