/*
 * scandialog.h
 *
 * Copyright (C) 2004-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef SCANDIALOG_H
#define SCANDIALOG_H

#include <tqtimer.h>
#include <tqprogressbar.h>
#include <tqlabel.h>

#include <kled.h>

#include "kgradprogress.h"
#include "scandialogui.h"
#include "channeldesc.h"

class DVBsi;
class DvbStream;



class DListViewItem : public TQListViewItem
{

public:

	DListViewItem( TQListView *parent, ChannelDesc *desc, TQString label1, TQString label2 );

	ChannelDesc *chan;
};



class ScanDialog : public ScanDialogUI
{
	TQ_OBJECT
  

public:

	ScanDialog( TQPtrList<DvbStream> *d, TQPtrList<ChannelDesc> *ch, TQSize size, TQString src, const TQString &charset );
	~ScanDialog();

	TQPtrList<Transponder> transponders;
	TQPtrList<ChannelDesc> *chandesc;

private slots:

	void scan( bool b );
	void checkNewChannel();
	void setLock( bool on );
	void siEnded( bool b );
	void addFiltered();
	void addSelected();
	void setProgress();
	void pop( TQListViewItem *it, const TQPoint &pos, int col );
	void deleteAll();
	void selectAll();
	void newChannel();
	void deleteChannel( TQString name );
	void deleteChannel();
	void setDvb(int);
	void slotChannelChanged( TQListViewItem*, const TQPoint &, int );

private:

	bool getTransData();
	bool edit( TQString &name, TQPixmap &pix );
	void working( bool b );
	void parseTp( TQString s, fe_type_t type, TQString src );
	void addFound( ChannelDesc *chan, bool scan );
	void checkDuplicateName( ChannelDesc *chan );
	bool checkChannUpdate( ChannelDesc *chan );

	TQPtrList<DvbStream> *dvb;
	DvbStream *ds;
	KGradProgress *snr, *signal;
	TQProgressBar *progress;
	KLed *lock;
	DVBsi *dvbsi;
	TQTimer checkTimer, progressTimer;
	int nChannels;
	TQPixmap tvPix, raPix, tvcPix, racPix;
	int ntv, nradio;
	TQLabel *progressLab;
	TQString sourcesPath;
	TQString defaultCharset;
};

#endif /* SCANDIALOG_H */
