/***************************************************************************
 *   Copyright (C) 2005 by Lorenzo Bettini                                 *
 *   http://www.lorenzobettini.it                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "klcddimmerapplet.h"

#include <tqpixmap.h>
#include <tqlabel.h>
#include <kiconloader.h>
#include <tqlayout.h>

KlcdDimmerApplet::KlcdDimmerApplet(TQWidget *parent, const char *name)
 : TQWidget(parent, name)
{
  // the icon and the text will be aligned vertically centered
  layout = new TQVBoxLayout(this);

  brightnessIcon = new TQLabel(this);
  brightnessIcon->setAlignment(AlignCenter);
  brightnessIcon->setBackgroundOrigin(AncestorOrigin);
  brightnessLevel = new TQLabel(this);
  brightnessLevel->setAlignment(AlignCenter);
  // use the same background of the panel
  brightnessLevel->setBackgroundOrigin(AncestorOrigin);

  layout->addWidget(brightnessIcon);
  layout->addWidget(brightnessLevel);

  brightnessIcon->setPixmap(SmallIcon("klcddimmer"));
}


KlcdDimmerApplet::~KlcdDimmerApplet()
{
}

void KlcdDimmerApplet::setBrightnessLevel(const TQString &level)
{
  brightnessLevel->setText(level);
}

#include "klcddimmerapplet.moc"
