#!/bin/sh
#
# %coypright%
#
# Please report bugs to: %maintainer%
#
# %license%
#
# Installer Package script for KMyFirewall %version%
# This is an automatic generated file DO NOT EDIT

DATA="%data%"

REQUIREDTOOLS="bash stat openssl tar gzip"
EXTRACTDIR="/tmp/kmyfirewall.d"
CURRDIR=`pwd`
EXTRACTPATH=$EXTRACTDIR

INERACTIVE="1"

checkRequirements() {
	USR=`whoami`
	if [ "$USR" != "root" ]; then
		echo
		echo "This script need to be run as root."
		echo
		exit 1;
	fi
	
	echo -n "Checking system requirements...\t\t"
	for PROG in $REQUIREDTOOLS; do
		if [ "$INERACTIVE" = "1" ]; then
			echo -n  "Checking for $PROG...\t\t "
		fi
		PROGPATH=`which $PROG`
		if [ "$?" != "0" ]; then
			echo
			echo "ERROR: $PROG not found. Installation aborted!"
			echo 
			exit 1
		fi
		if [ "$INERACTIVE" = "1" ]; then
			echo " found $PROG at $PROGPATH"
		fi
	done
	echo "Done"
}

extract() {
	if [ "$INERACTIVE" = "1" ]; then
		echo "Enter the path to the directory used to"
		echo "extract the installation files"
		echo
		echo -n "Extract to [$EXTRACTPATH]: "
		
		read newpath
		if [ "$newpath" != "" ]; then
			EXTRACTDIR=$newpath
		fi
	fi
	EXTRACTPATH=$EXTRACTDIR
	# EXTRACTPATH=$EXTRACTDIR
	
	if [ -e  $EXTRACTPATH ]; then
		realydel="n"
		if [ "$INERACTIVE" = "1" ]; then
			echo "$EXTRACTPATH allready exists. Do you want to delete it? [y/N]"
			read realydel
		else 
			realydel="y"
		fi
		
		if [ "$realydel" != "y" ]; then
			extract
		else 
			if [ "$INERACTIVE" = "1" ]; then
				echo "Deleting $EXTRACTPATH..."
			fi
			rm -rf "$EXTRACTPATH"
		fi
	fi
	
	echo "Exctracting data to $EXTRACTPATH..."
	mkdir "$EXTRACTPATH"
	cd "$EXTRACTPATH"
	
	touch data.b64
	for LINE in $DATA; do
		echo $LINE >> data.b64
	done
 	
 	openssl base64 -d -in data.b64 -out data.tar.gz
	rm data.b64
	tar xfz data.tar.gz
	# cd "$CURRDIR"
	echo
}

install() {
	cd "$EXTRACTPATH"
	
	if [ "$INERACTIVE" = "1" ]; then
		bash install.sh --install
	else 
		bash install.sh -q --install
	fi
	
	# cd "$CURRDIR"
}

uninstall() {
	cd "$EXTRACTPATH"

	if [ "$INERACTIVE" = "1" ]; then
		bash install.sh --uninstall
	else 
		bash install.sh -q --uninstall
	fi
	# cd "$CURRDIR"
}

start() {
	cd "$EXTRACTPATH"
	
	if [ "$INERACTIVE" = "1" ]; then
		bash data/kmyfirewall.sh -v start
	else 
		bash data/kmyfirewall.sh -v start
	fi
	
	# cd "$CURRDIR"
}
stop() {
	cd "$EXTRACTPATH"
	
	if [ "$INERACTIVE" = "1" ]; then
		bash data/kmyfirewall.sh -v stop
	else 
		bash data/kmyfirewall.sh -v stop
	fi
	
	# cd "$CURRDIR"
}


reinstall() {
	cd "$EXTRACTPATH"
	bash install.sh --reinstall
	if [ "$INERACTIVE" = "1" ]; then
		bash install.sh --reinstall
	else 
		bash install.sh -q --reinstall
	fi
	# cd "$CURRDIR"
}

delpackage() {
	realydel="y"
	
	if [ "$INERACTIVE" = "1" ]; then
		echo -n "Do you want to delete the extracted installation files? [Y/n]: "
		read realydel
	fi
	
	if [ "$realydel" != "n" ]; then
		# if [ "$INERACTIVE" = "1" ]; then
			echo -n "Deleting $EXTRACTPATH...\t\t"
		# fi
		rm -rf "$EXTRACTPATH"
		echo "Done"
	fi 
	echo
}

copyToInstallDir() {
	cd "$CURRDIR"
	echo "Copy installer package to /etc/kmyfirewall/kmfpackage.kmfpkg...\t\t"
	cp $0 /etc/kmyfirewall/
	echo "Done"
}

printHello() {
    echo "KMyFirewall Installer Package v%version%"
    echo "Please report bugs to: %maintainer%"
    echo
}
printHelp() {
	echo "Usage: $0 [-q] { --install | --uninstall | --reinstall | --extract | --start | --stop | --help }"
	echo
	echo "Switches"
	echo "	-q"
	echo "		No not require any user interaction."
	echo
	echo "Options:"
	echo "	install|--install|-i"
	echo "		Install the configuration."
	echo "		The installed firewall scrip will be automaticaly run at system boot."
	echo 
	echo "	uninstall|--uninstall|-u"
	echo "		Uninstall the configuration form the system."
	echo 
	echo "	reinstall|--reinstall|-r"
	echo "		Re-Installs the configuration e.g. the same as install.sh uninstall"
	echo "		followed by install.sh install"
	echo
	echo "	extract|--extract|-e"
	echo "		Only extract the installation files."
	echo "		The firewall will not be installed."
	echo 
	echo "	start|--start|-s"
	echo "		Only extract the installation files and."
	echo "		runs the firewall script."
	echo "		The firewall will not be installed."
	echo 
	echo "	stop|--stop|-c"
	echo "		Only extract the installation files and."
	echo "		stops the firewall script."
	echo "		The firewall will not be installed."
	echo 
	echo "	help|--help|-h"
	echo "		Print this help message"
	echo
}

#
# Execution starts here
#

COMMAND=$1

if [ "$COMMAND" = "-q" ]; then
	COMMAND="$2"
	INERACTIVE="0";
fi

printHello

case $COMMAND in
	install|--install|-i)
	checkRequirements
	extract
    install
    delpackage
    copyToInstallDir
	;;

    uninstall|--uninstall|-u)
    checkRequirements
    extract
    # install
    uninstall
    delpackage
    ;;
    
	reinstall|--reinstall|-r)
	checkRequirements
	extract
    reinstall
    delpackage
    copyToInstallDir
	;;
	
	extract|--extract|-e)
	checkRequirements
	extract
	;;
	
	start|--start|-s)
	checkRequirements
	extract
	start
	delpackage
	copyToInstallDir
	;;
	
	stop|--stop|-c)
	checkRequirements
	extract
	stop
	delpackage
	copyToInstallDir
	;;
	
	help|--help|-h)
	printHelp
	;;

	*)
	checkRequirements
	extract
    install
    delpackage
    copyToInstallDir
    ;;
esac