//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfsystemsettingslinux.h"


// TQt Includes
#include <tqlabel.h>

// KDE includes
#include <tdelocale.h>
#include <kcombobox.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kurlrequester.h>
#include <kguiitem.h>
#include <kpushbutton.h>
#include <knuminput.h>
#include <tdelistbox.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <tdeglobal.h>
#include <tdemessagebox.h>
#include <tdelistview.h>

// Prokject includes
#include "../core/kmftarget.h"
#include "../core/kmftargetconfig.h"
#include "../core/kmfundoengine.h"
namespace KMF {
KMFSystemSettingsLinux::KMFSystemSettingsLinux(TQWidget* parent, const char* name, WFlags fl)
: KMyFirewallSystemSettingsLinux(parent,name,fl)
{
	m_url_ipt_path->setMode( KFile::Files | KFile::LocalOnly );
	m_url_mod_path->setMode( KFile::Files | KFile::LocalOnly );
	m_url_init_path->setMode( KFile::Directory | KFile::LocalOnly );
	m_url_runlevel_path->setMode( KFile::Directory | KFile::LocalOnly );
	
	connect( m_url_ipt_path, TQ_SIGNAL( textChanged( const TQString& ) ),
		this, TQ_SLOT( slotSettingChanged() ) );
	connect( m_url_mod_path, TQ_SIGNAL( textChanged( const TQString& ) ),
		this, TQ_SLOT( slotSettingChanged() ) );
	connect( m_url_init_path, TQ_SIGNAL( textChanged( const TQString& ) ),
		this, TQ_SLOT( slotSettingChanged() ) );
	connect( m_url_runlevel_path, TQ_SIGNAL( textChanged( const TQString& ) ),
		this, TQ_SLOT( slotSettingChanged() ) );
	connect( m_cob_distribution, TQ_SIGNAL( activated( const TQString& ) ),
		this, TQ_SLOT( slotDistributionChanged() ) );
}

KMFSystemSettingsLinux::~KMFSystemSettingsLinux()
{
}


/*$SPECIALIZATION$*/
void KMFSystemSettingsLinux::loadTarget( KMFTarget* target ) {
	kdDebug() << "KMFInterfaceWidget::loadTarget( KMFTarget* target )" << endl;
	m_target = target;
	updateView();
}

void KMFSystemSettingsLinux::updateView(){
	kdDebug() << "KMFInterfaceWidget::updateView()" << endl;
	if ( ! m_target ) {
		kdDebug() << "KMFInterfaceWidget::updateView() - ERROR: m_target == 0 " << endl;
		return;
	}
	KMFTargetConfig *conf = m_target->config();

	kdDebug() << "KMFInterfaceWidget::updateView() - config: " << endl;
	kdDebug() << conf->toString() << endl;
	
	m_url_ipt_path->blockSignals( true );
	m_url_mod_path->blockSignals( true );
	m_url_init_path->blockSignals( true );
	m_url_runlevel_path->blockSignals( true );
	
	if ( conf->distribution() == "sysv" ) {
		m_cob_distribution->setCurrentItem( 0 );
	} else if ( conf->distribution() == "gentoo" ) {
		m_cob_distribution->setCurrentItem( 1 );
	} else if ( conf->distribution() == "slackware" ) {
		m_cob_distribution->setCurrentItem( 2 );
	}
	slotDistributionChanged();
	
	
	
	kdDebug() <<  "set conf->IPTPath()" << conf->IPTPath() << endl;
	m_url_ipt_path->setURL( conf->IPTPath() );
	
	kdDebug() <<  "set conf->modprobePath()" << conf->modprobePath() << endl;
	m_url_mod_path->setURL( conf->modprobePath() );
	
	kdDebug() <<  "set conf->initPath()" << conf->initPath() << endl;
	m_url_init_path->setURL( conf->initPath() );
	
	kdDebug() <<  "set conf->rcDefaultPath()" << conf->rcDefaultPath() << endl;
	m_url_runlevel_path->setURL( conf->rcDefaultPath() );

	m_url_ipt_path->blockSignals( false );
	m_url_mod_path->blockSignals( false );
	m_url_init_path->blockSignals( false );
	m_url_runlevel_path->blockSignals( false );
}

void KMFSystemSettingsLinux::slotDistributionChanged() {
	KMFTargetConfig *conf = m_target->config();
	switch ( m_cob_distribution->currentItem() ) {
		case 0:
		conf->setDistribution( "sysv" );
		m_url_init_path->setShown( true );
		m_lab_init_path->setShown( true );
		return;
		break;

		case 1:
		conf->setDistribution( "gentoo" );
		m_url_runlevel_path->setURL( "/etc/runlevels/default/" );
		m_url_ipt_path->setURL( "/sbin/iptables" );
		m_url_mod_path->setURL( "/sbin/modprobe" );
		m_url_init_path->setURL( "/etc/init.d/" );
		m_url_init_path->setShown( true );
		m_lab_init_path->setShown( true );
		break;

		case 2:
		conf->setDistribution( "slackware" );
		m_url_runlevel_path->setURL( "/etc/rc.d/" );
		m_url_ipt_path->setURL( "/usr/sbin/iptables" );
		m_url_mod_path->setURL( "/usr/sbin/modprobe" );
		m_url_init_path->setShown( false );
		m_lab_init_path->setShown( false );
		break;
	}
	KMFUndoEngine::instance()->startTransaction(
		conf,
		i18n( "Change system settings of target: %1" ).arg( conf->target()->guiName() )
	);
	conf->setIPTPath( m_url_ipt_path->url() );
	conf->setModprobePath( m_url_mod_path->url() );
	conf->setInitPath( m_url_init_path->url() );
	conf->setRcDefaultPath( m_url_runlevel_path->url() );
	KMFUndoEngine::instance()->endTransaction();
}

void KMFSystemSettingsLinux::slotSettingChanged() {
	kdDebug() << "KMFInterfaceWidget::slotSettingChanged()" << endl;
	KMFTargetConfig *conf = m_target->config();
	switch ( m_cob_distribution->currentItem() ) {
		case 0:
		conf->setDistribution( "sysv" );
		break;

		case 1:
		conf->setDistribution( "gentoo" );
		break;

		case 2:
		conf->setDistribution( "slackware" );
		break;
	}
	KMFUndoEngine::instance()->startTransaction(
		conf,
		i18n( "Change system settings of target: %1" ).arg( conf->target()->guiName() )
	);
	conf->setIPTPath( m_url_ipt_path->url() );
	conf->setModprobePath( m_url_mod_path->url() );
	conf->setInitPath( m_url_init_path->url() );
	conf->setRcDefaultPath( m_url_runlevel_path->url() );
	KMFUndoEngine::instance()->endTransaction();
}

}

#include "kmfsystemsettingslinux.moc"

