/***************************************************************************
 begin                : Wed May 22 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleedittargetlog.h" 

// TQt includes
#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqlineedit.h>

// kde includes
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdelocale.h> 

// MY includes
#include "../../core/xmlnames.h"
#include "../../core/iptrule.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"
namespace KMF {
KMFRuleEditTargetLog::KMFRuleEditTargetLog( TQWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTargetLog( parent, name, fl ) {}
KMFRuleEditTargetLog::~KMFRuleEditTargetLog() {}

void KMFRuleEditTargetLog::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditTargetLog::loadRule( IPTRule* rule )" << endl;
	c_log_tcp_seq->setChecked( false );
	c_log_tcp_options-> setChecked( false );
	c_log_ip_options->setChecked( false );
	c_log_prefix-> setChecked( false );
	c_log_level ->setChecked( false );
	cb_log_level->setCurrentItem( 0 );
	t_log_prefix->clear();
	m_rule = rule;
	IPTRuleOption *opt = 0;
	opt = m_rule->getOptionForName("target_log_opt");
	if (opt) {
		TQStringList vals = opt->getValues();
		TQString prefix = "";
		TQString level = "";
		TQString tcp_seq = "";
		TQString tcp_opt = "";
		TQString ip_opt = "";
		prefix = *vals.at(0);
		level = *vals.at(1);
		tcp_seq = *vals.at(2);
		tcp_opt = *vals.at(3);
		ip_opt =* vals.at(4);
		if ( !prefix.isEmpty() && prefix != XML::Undefined_Value && prefix != XML::BoolOff_Value ) {
			c_log_prefix->setChecked( true );
			prefix = prefix.right( prefix.length() -1);
			prefix = prefix.left( prefix.length() -1 );
			t_log_prefix->setText( prefix );
		} else {
			c_log_prefix->setChecked( false );
 			t_log_prefix->setText( "" );
		}
		if ( !level.isEmpty() && level != XML::Undefined_Value && prefix != XML::BoolOff_Value) {
			c_log_level->setChecked( true );
			cb_log_level ->setCurrentText( level );
		} else {
			c_log_level->setChecked( false );
			cb_log_level ->setCurrentText( "" );
		}

		if ( tcp_seq == XML::BoolOn_Value )
			c_log_tcp_seq->setChecked( true );
		else
			c_log_tcp_seq->setChecked( false );

		if ( tcp_opt == XML::BoolOn_Value )
			c_log_tcp_options->setChecked( true );
		else
			c_log_tcp_options->setChecked( false );

		if ( ip_opt == XML::BoolOn_Value )
			c_log_ip_options->setChecked( true );
		else
			c_log_ip_options->setChecked( false );
	}
}

void KMFRuleEditTargetLog::accept() {
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 Target Log Option").arg( m_rule->name() ) 
	);
	TQPtrList<TQString>* args = new TQPtrList<TQString>;
	TQString* name = new TQString( "target_log_opt" );

	if ( c_log_prefix->isChecked() ) {
		TQString val = t_log_prefix->text();
		val.prepend("\"");
		val.append("\"");
		args->append( ( new TQString( val ) ) );
	} else {
		args->append( ( new TQString("") ) );
	}

	if ( c_log_level->isChecked() ) {
		TQString val = cb_log_level->currentText();
		args->append( ( new TQString( val ) ) );
	} else {
		args->append( ( new TQString("") ) );
	}

	if ( c_log_tcp_seq->isChecked() ) {
		TQString val = XML::BoolOn_Value;
		args->append( ( new TQString( val ) ) );
	} else {
		args->append( ( new TQString("") ) );
	}

	if ( c_log_tcp_options->isChecked() ) {
		TQString val = XML::BoolOn_Value;
		args->append( ( new TQString( val ) ) );
	} else {
		args->append( ( new TQString("") ) );
	}

	if ( c_log_ip_options->isChecked() ) {
		TQString val = XML::BoolOn_Value;
		args->append( ( new TQString( val ) ) );
	} else {
		args->append( ( new TQString("") ) );
	}

	// emit sigAddTargetOpt(name,args);
	m_rule->addTargetOption( *name, *args );
	emit sigDocumentChanged();
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditTargetLog::slotHelp() {
	kdDebug() << "void KMFRuleEditTargetLog::slotHelp()" << endl;
	tdeApp->invokeHelp( "targets" );
}
void KMFRuleEditTargetLog::reject() {
	kdDebug() << "void KMFRuleEditTargetLog::slotreject()" << endl;
	emit sigHideMe();
}

}

#include "kmfruleedittargetlog.moc"
