/***************************************************************************
                          registersearchline.h
                             -------------------
    begin                : Sun Jan 14 2006
    copyright            : (C) 2006 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REGISTERSEARCHLINE_H
#define REGISTERSEARCHLINE_H

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqhbox.h>

// ----------------------------------------------------------------------------
// TDE Includes

#include <klineedit.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/register.h>
#include <kmymoney/export.h>

namespace KMyMoneyRegister {

/**
  * This class makes it easy to add a search line for filtering the items
  * in a register based on simple text.  Inspired by the idea of the tdelibs
  * class TDEListViewSearchLine.
  *
  * @author Thomas Baumgart
  */
class KMYMONEY_EXPORT RegisterSearchLine : public KLineEdit
{
  TQ_OBJECT
  
public:
  /**
    * Constructs a RegisterSearchLine with @a reg being the register to be
    * filtered.
    *
    * If @a reg is null then the widget will be disabled until a register
    * is set with setRegister().
    */
  RegisterSearchLine(TQWidget* parent = 0, Register* reg = 0, const char* name = 0);

  /**
    * Constructs a RegisterSearchLine
    *
    * The widget will be disabled until a register is set with setRegister().
    */
  RegisterSearchLine(TQWidget* parent = 0, const char* name = 0);

  /**
    * Destroys the object
    */
  ~RegisterSearchLine();

  /**
    * Sets the KMyMoneyRegister that is filtered by this search line.
    * If @a reg is null then the widget will be disabled.
    *
    * @see KMyMoneyRegister()
    */
  void setRegister(Register* reg);

protected:
  virtual bool itemMatches(const RegisterItem* item, const TQString& s) const;

public slots:
  virtual void updateSearch(const TQString& s = TQString());
  virtual void reset(void);

protected slots:
  void queueSearch(const TQString& search);
  void activateSearch(void);
  void slotStatusChanged(int);

private slots:
  void itemAdded(RegisterItem* item) const;
  void registerDestroyed(void);

private:
  void init(Register* reg);

private:
  class RegisterSearchLinePrivate;
  RegisterSearchLinePrivate* const d;
};

/**
  * Creates a widget containing a RegisterSearchLine, a label with the text
  * "Search" and a button to clear the search. Modelled after TDEListViewSearchLineWidget.
  *
  * @author Thomas Baumgart
  */
class KMYMONEY_EXPORT RegisterSearchLineWidget : public TQHBox
{
  TQ_OBJECT
  
public:
  /**
    * Creates a RegisterSearchLineWidget for @a reg with @a parent as the
    * parent and with @a name.
    */
  RegisterSearchLineWidget(Register* reg = 0, TQWidget* parent = 0, const char* name = 0);

  /**
    * Destroys the object
    */
  ~RegisterSearchLineWidget();

  /**
    * Returns a pointer to the searchline
    */
  RegisterSearchLine* searchLine() const;

  /**
    * Creates the search line.  This can be useful to reimplement in cases where
    * a RegisterSearchLine subclass is used.
    */
  virtual RegisterSearchLine* createSearchLine(Register* reg);

protected slots:
  /**
    * Creates the widgets inside of the widget.  This is called from the
    * constructor via a single shot timer so that it is guaranteed to run
    * after construction is complete.  This makes it suitable for overriding in
    * subclasses.
    */
  virtual void createWidgets(void);

private:
  class RegisterSearchLineWidgetPrivate;
  RegisterSearchLineWidgetPrivate* const d;
};

} // namespace

#endif
