#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "KDChartParamsWrapper.h"
#include <KDChartParams.h>

KDChartParamsWrapper::KDChartParamsWrapper( KDChartParams* data ) :TQObject(0), _data(data)
{
}

const KDChartAxisParams* KDChartParamsWrapper::axisParams( uint n ) const
{
    const KDChartAxisParams& a = _data->axisParams( n );
    return &a;
}

void KDChartParamsWrapper::setExplodeValues( TQVariant explodeList )
{
    if ( !explodeList.type() == TQVariant::List )
        return;
    TQValueList<TQVariant> list = explodeList.toList();

    TQValueList<int> res;
    for( TQValueList<TQVariant>::Iterator it = list.begin(); it != list.end(); ++it ) {
        int x = (*it).toInt();
        res.append(x);
    }
    _data->setExplodeValues( res );
}

void KDChartParamsWrapper::setExplodeFactors( TQVariant factors )
{
    if ( !factors.type() == TQVariant::List )
        return;

    TQValueList<TQVariant> list = factors.toList();

    KDChartParams::ExplodeFactorsMap res;
    int i = 0;
    for( TQValueList<TQVariant>::Iterator it = list.begin(); it != list.end(); ++it, ++i ) {
        res[i] = (*it).toDouble();
    }
    _data->setExplodeFactors( res );
}

void KDChartParamsWrapper::setAxisLabelStringParams( uint n, TQVariant axisLabelStringList, TQVariant axisShortLabelStringList,
                                                     const TQString& valueStart, const TQString& valueEnd )
{
    TQStringList l1 = axisLabelStringList.toStringList();
    TQStringList l2 = axisShortLabelStringList.toStringList();
    _data->setAxisLabelStringParams( n, &l1, &l2, valueStart, valueEnd );
}

void KDChartParamsWrapper::setAxisLabelTextParams( uint n,
                                                   bool axisSteadyValueCalc,
                                                   TQVariant axisValueStart,
                                                   TQVariant axisValueEnd,
                                                   double axisValueDelta,
                                                   int axisDigitsBehindComma,
                                                   int axisMaxEmptyInnerSpan,
                                                   int takeLabelsFromDataRow,
                                                   int labelTextsDataRow,
                                                   const TQVariant& axisLabelStringList,
                                                   const TQVariant& axisShortLabelsStringList,
                                                   int axisValueLeaveOut,
                                                   int axisValueDeltaScale ) {

    TQStringList l1 = axisLabelStringList.toStringList();
    TQStringList l2 = axisShortLabelsStringList.toStringList();

    _data->setAxisLabelTextParams( n, axisSteadyValueCalc, axisValueStart, axisValueEnd, axisValueDelta, axisDigitsBehindComma, axisMaxEmptyInnerSpan,
                                   (KDChartAxisParams::LabelsFromDataRow) takeLabelsFromDataRow, labelTextsDataRow, &l1, &l2,
                                   axisValueLeaveOut, (KDChartAxisParams::ValueScale) axisValueDeltaScale );
}

#include "KDChartParamsWrapper.moc"
