/***************************************************************************
                          setpageengines.cpp  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "setpageengines.moc"

setPageEngines::setPageEngines(TQWidget *parent, resource *Rsrc  ) : TQVBoxLayout(parent)
{
	Parent = parent;
	Resource = Rsrc;
	Engine_Dialog = NULL;
	Engines_ListView = NULL;

	BOX_Current = new TQHBox( parent );
	addWidget( BOX_Current );

	/* Engines to play White */
	GROUP_White_Current = new TQGroupBox( 3,
																	TQt::Vertical,
																	i18n( "Engines to Play White" ),
																	BOX_Current );

	White_Use_Book = new TQCheckBox( i18n( "Enable Book Engine" ), GROUP_White_Current );
	Engines_White = new KComboBox ( GROUP_White_Current );
	Engines_White_Book = new KComboBox ( GROUP_White_Current );
	Engines_White->setEditable( false );
	Engines_White_Book->setEditable( false );

	/* Engines to play Black */
	GROUP_Black_Current = new TQGroupBox( 3,
																	TQt::Vertical,
																	i18n( "Engines to Play Black" ),
																	BOX_Current );

	Black_Use_Book = new TQCheckBox( i18n( "Enable Book Engine" ), GROUP_Black_Current );
	Engines_Black = new KComboBox ( GROUP_Black_Current );
	Engines_Black_Book = new KComboBox ( GROUP_Black_Current );
	Engines_Black->setEditable( false );
	Engines_Black_Book->setEditable( false );

	/* Chess Engines ListView */
	GROUP_Engines = new TQGroupBox(	2,
																	TQt::Horizontal,
																	i18n( "Chess Engines" ),
																	parent );
	addWidget( GROUP_Engines );

	Engines_ListView = new TDEListView( GROUP_Engines );
	Engines_ListView->addColumn( i18n( "Name" ) );
	Engines_ListView->addColumn( i18n( "Protocol" ) );
	Engines_ListView->addColumn( i18n( "Wins" ) );
	Engines_ListView->addColumn( i18n( "Losses" ) );
	Engines_ListView->addColumn( i18n( "Draws" ) );
	Engines_ListView->setAllColumnsShowFocus( true );
	Engines_ListView->setMultiSelection( false );
	Engines_ListView->setShowSortIndicator( true );
	Engines_ListView->restoreLayout( tdeApp->config(), "Engines_ListView" );

	Engines_ButtonBox = new KButtonBox( GROUP_Engines,TQt::Vertical );
		Engines_Button_Add = Engines_ButtonBox->addButton( i18n( "&Add..." ) );
		Engines_Button_Change = Engines_ButtonBox->addButton( i18n( "&Modify..." ) );
		Engines_Button_Delete = Engines_ButtonBox->addButton( i18n( "&Delete..." ) );
		Engines_ButtonBox->layout();

	BuildEngineData();

	connect( Engines_Button_Add, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotEngine_Add() ) );
	connect( Engines_Button_Change, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotEngine_Modify() ) );
	connect( Engines_Button_Delete, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotEngine_Delete() ) );
	connect( Engines_White, TQ_SIGNAL( activated(int) ), this, TQ_SLOT( slotCurrent_White(int) ) );
	connect( Engines_White_Book, TQ_SIGNAL( activated(int) ), this, TQ_SLOT( slotCurrent_White_Book(int) ) );
	connect( Engines_Black, TQ_SIGNAL( activated(int) ), this, TQ_SLOT( slotCurrent_Black(int) ) );
	connect( Engines_Black_Book, TQ_SIGNAL( activated(int) ), this, TQ_SLOT( slotCurrent_Black_Book(int) ) );
	connect( White_Use_Book, TQ_SIGNAL( toggled(bool) ), this, TQ_SLOT( slotToggle_White_Book(bool) ) );
	connect( Black_Use_Book, TQ_SIGNAL( toggled(bool) ), this, TQ_SLOT( slotToggle_Black_Book(bool) ) );
	connect( Engines_ListView, TQ_SIGNAL( selectionChanged() ), this, TQ_SLOT( selectionChanged() ) );
}
setPageEngines::~setPageEngines()
{
	Engines_ListView->saveLayout( tdeApp->config(), "Engines_ListView" );
	delete Engines_ButtonBox;
	delete Engines_ListView;
	delete GROUP_Engines;
	delete GROUP_Black_Current;
	delete GROUP_White_Current;
}
///////////////////////////////////////
//
//	setPageEngines::BuildEngineData
//
///////////////////////////////////////
void setPageEngines::BuildEngineData( void )
{
	bool 	WHITE_FLAG(false),
				WHITE_BK_FLAG(false),
				BLACK_FLAG(false),
				BLACK_BK_FLAG(false);
	TQStringList EngineList;
	TQString proto;
	int Index(0);
	engineList::Iterator	enginesIT;

	/* Clear Comboboxes */
	Engines_White->clear();
	Engines_White_Book->clear();
	Engines_Black->clear();
	Engines_Black_Book->clear();
	Engines_ListView->clear();

	/* Handle status of Book-engine boxes */
	White_Use_Book->setChecked( Resource->OPTION_Book_White );
	Black_Use_Book->setChecked( Resource->OPTION_Book_Black );
	Engines_White_Book->setEnabled( Resource->OPTION_Book_White );
	Engines_Black_Book->setEnabled( Resource->OPTION_Book_Black );

	/* Read the engine list */
	if( Resource->engines.isEmpty() ) return;
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		switch( (*enginesIT).Protocol )
		{
			case UCI:
				proto = "UCI";
				break;
			case XBoard: // Fall through
			default:
				proto = "XBoard";
				break;
		}
		(void) new TQListViewItem( Engines_ListView,
															(*enginesIT).Name,
															proto,
															TQString( "%1" ).arg( (*enginesIT).Wins ),
															TQString( "%1" ).arg( (*enginesIT).Losses ),
															TQString( "%1" ).arg( (*enginesIT).Draws ) );
		EngineList.append( (*enginesIT).Name );
	}

	/* Insert engines into comboboxes */
	EngineList.sort();
	Engines_White->insertStringList( EngineList );
	Engines_Black->insertStringList( EngineList );
	Engines_White_Book->insertStringList( EngineList );
	Engines_Black_Book->insertStringList( EngineList );

	/* Now run the list again, setting the current engine for each combobox */
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & ENGINE_WHITE_BK )
			for( Index = 0; Index < Engines_White_Book->count(); Index++ )
				if( Engines_White_Book->text(Index) == (*enginesIT).Name )
				{
					Engines_White_Book->setCurrentItem(Index);
					WHITE_BK_FLAG = true;
				}
		if( (*enginesIT).CurrentRef & ENGINE_BLACK_BK )
			for( Index = 0; Index < Engines_Black_Book->count(); Index++ )
				if( Engines_Black_Book->text(Index) == (*enginesIT).Name )
				{
					Engines_Black_Book->setCurrentItem(Index);
					BLACK_BK_FLAG = true;
				}
		if( (*enginesIT).CurrentRef & ENGINE_WHITE )
			for( Index = 0; Index < Engines_White->count(); Index++ )
				if( Engines_White->text(Index) == (*enginesIT).Name )
				{
					Engines_White->setCurrentItem(Index);
					WHITE_FLAG = true;
				}
		if( (*enginesIT).CurrentRef & ENGINE_BLACK )
			for( Index = 0; Index < Engines_Black->count(); Index++ )
				if( Engines_Black->text(Index) == (*enginesIT).Name )
				{
					Engines_Black->setCurrentItem(Index);
					BLACK_FLAG = true;
				}
	}

	/* This prevents a bug where you had to modify the current_engine_comboboxes
		before you could get any engines to run. */
	if( ( !WHITE_FLAG ) && ( Engines_White->count() ) ) slotCurrent_White( Engines_White->currentItem() );
	if( ( !BLACK_FLAG ) && ( Engines_Black->count() ) ) slotCurrent_Black( Engines_Black->currentItem() );
	if( ( !WHITE_BK_FLAG ) && ( Engines_White_Book->count() ) ) slotCurrent_White_Book( Engines_White_Book->currentItem() );
	if( ( !BLACK_BK_FLAG ) && ( Engines_Black_Book->count() ) ) slotCurrent_Black_Book( Engines_Black_Book->currentItem() );

	Engines_Button_Change->setEnabled( false );
	Engines_Button_Delete->setEnabled( false );
}
///////////////////////////////////////
//
//	setPageEngines::slotEngine_Add
//
///////////////////////////////////////
void setPageEngines::slotEngine_Add( void )
{
	Engine_Dialog = new dlg_engine( Parent, "EngineDialog", Resource );
	connect( Engine_Dialog, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( BuildEngineData() ) );
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotEngine_Modify
//
///////////////////////////////////////
void setPageEngines::slotEngine_Modify( void )
{
	TQListViewItem *Item;
	TQPtrList<TQListViewItem> Select = Engines_ListView->selectedItems();

	if( Select.isEmpty() ) return;
	Item = Select.first();
	Engine_Dialog = new dlg_engine( Parent, "EngineDialog", Resource, Item->text(0) );
	connect( Engine_Dialog, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( BuildEngineData() ) );
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotEngine_Delete
//
///////////////////////////////////////
void setPageEngines::slotEngine_Delete( void )
{
	engineList::Iterator	enginesIT;
	TQListViewItem *Item;
	TQPtrList<TQListViewItem> Select = Engines_ListView->selectedItems();

	if( Select.isEmpty() ) return;
	Item = Select.first();

	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).Name == Item->text(0) ) break;
	}
	Resource->engines.remove(enginesIT);
	BuildEngineData();
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotCurrent_White
//
///////////////////////////////////////
void setPageEngines::slotCurrent_White( int Index )
{
	TQString Name;
	engineList::Iterator	enginesIT;
	
	Name = Engines_White->text(Index);
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & ENGINE_WHITE ) (*enginesIT).CurrentRef -= ENGINE_WHITE;
		if( (*enginesIT).Name == Name ) (*enginesIT).CurrentRef |= ENGINE_WHITE;
	}
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotCurrent_White_Book
//
///////////////////////////////////////
void setPageEngines::slotCurrent_White_Book( int Index )
{
	TQString Name;
	engineList::Iterator	enginesIT;
	
	Name = Engines_White_Book->text(Index);
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & ENGINE_WHITE_BK ) (*enginesIT).CurrentRef -= ENGINE_WHITE_BK;
		if( (*enginesIT).Name == Name ) (*enginesIT).CurrentRef |= ENGINE_WHITE_BK;
	}
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotCurrent_Black
//
///////////////////////////////////////
void setPageEngines::slotCurrent_Black( int Index )
{
	TQString Name;
	engineList::Iterator	enginesIT;
	
	Name = Engines_Black->text(Index);
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & ENGINE_BLACK ) (*enginesIT).CurrentRef -= ENGINE_BLACK;
		if( (*enginesIT).Name == Name ) (*enginesIT).CurrentRef |= ENGINE_BLACK;
	}
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotCurrent_Black_Book
//
///////////////////////////////////////
void setPageEngines::slotCurrent_Black_Book( int Index )
{
	TQString Name;
	engineList::Iterator	enginesIT;
	
	Name = Engines_Black_Book->text(Index);
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & ENGINE_BLACK_BK ) (*enginesIT).CurrentRef -= ENGINE_BLACK_BK;
		if( (*enginesIT).Name == Name ) (*enginesIT).CurrentRef |= ENGINE_BLACK_BK;
	}
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotToggle_White_Book
//
///////////////////////////////////////
void setPageEngines::slotToggle_White_Book( bool state )
{
	Resource->OPTION_Book_White = state;
	BuildEngineData();
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::slotToggle_Black_Book
//
///////////////////////////////////////
void setPageEngines::slotToggle_Black_Book( bool state )
{
	Resource->OPTION_Book_Black = state;
	BuildEngineData();
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageEngines::selectionChanged
//
///////////////////////////////////////
void setPageEngines::selectionChanged( void )
{
	if( Engines_ListView->selectedItem() == 0 )
	{
		Engines_Button_Change->setEnabled( false );
		Engines_Button_Delete->setEnabled( false );
	}
	else
	{
		Engines_Button_Change->setEnabled( true );
		Engines_Button_Delete->setEnabled( true );
	}
}
