#ifndef _kchartWIZARDSELECTCHARTTYPEPAGE_H
#define _kchartWIZARDSELECTCHARTTYPEPAGE_H

#include <tqlayout.h>
#include <tqvbox.h>
#include <tqwidget.h>

#include "kchart_params.h"

class TQFrame;
class TQPushButton;
class TQButtonGroup;

namespace KChart
{

class KChartPart;

// Contains a button with a text label below it
//
// FIXME: Move to kchartWizardSelectChartTypePage.cpp
class KChartButton : public TQVBox
{
  TQ_OBJECT
  
  public:
    KChartButton(TQWidget* parent, const TQString &, const TQPixmap &);
    ~KChartButton();

    TQPushButton *button() const { return m_button;}
  private:
    TQPushButton *m_button;
};

class KChartWizardSelectChartTypePage : public TQWidget
{
  TQ_OBJECT
  

public:
  KChartWizardSelectChartTypePage( TQWidget* parent, KChartPart* chart );

public slots:
  void  apply();

private slots:
  void  chartTypeSelected( int type );

signals:
  void  chartChange(int);

private:
  void  addButton(const TQString &name, const TQString &icon_name, int type);
  void  incPos();

private:
  KChartPart    *m_chart;

  TQButtonGroup  *m_typeBG;
  TQGridLayout   *m_layout;

  // column and row position (used by addButton() to know where to put
  // the new button)
  int            m_colPos;
  int            m_rowPos;

  KChartParams::ChartType  m_type;

};

}  //namespace KChart

#endif
