/* This file is part of the KDE project
   Copyright (C) 2001 Andrea Rizzi <rizzi@kde.org>
	              Ulrich Kuettler <ulrich.kuettler@mailbox.tu-dresden.de>
   Copyright (C) 2006 Alfredo Beaumont Sainz <alfredo.beaumont@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqfile.h>
#include <tqregexp.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqtextstream.h>
#include <tqfontmetrics.h>

#include <tdeconfig.h>
#include <kdebug.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>

#include "symboltable.h"
#include "contextstyle.h"
#include "unicodetable.cpp"


KFORMULA_NAMESPACE_BEGIN

#include "symbolfontmapping.cpp"

SymbolFontHelper::SymbolFontHelper()
    : greek("abgdezhqiklmnxpvrstufjcywGDTQLXPSUFYVW")
{
    for ( uint i = 0; symbolMap[ i ].unicode != 0; i++ ) {
        compatibility[ symbolMap[ i ].pos ] = symbolMap[ i ].unicode;
    }
}

TQChar SymbolFontHelper::unicodeFromSymbolFont( TQChar pos ) const
{
    if ( compatibility.contains( pos ) ) {
        return compatibility[ pos.latin1() ];
    }
    return TQChar::null;
}


SymbolTable::SymbolTable()
{
}


void SymbolTable::init( const TQFont& font )
{
    backupFont = font;
    for ( int i=0; operatorTable[i].unicode != 0; ++i ) {
        names[TQChar( operatorTable[i].unicode )] = get_name( operatorTable[i] );
        entries[get_name( operatorTable[i] )] = TQChar( operatorTable[i].unicode );
    }
    for ( int i=0; arrowTable[i].unicode != 0; ++i ) {
        names[TQChar( arrowTable[i].unicode )] = get_name( arrowTable[i] );
        entries[get_name( arrowTable[i] )] = TQChar( arrowTable[i].unicode );
    }
    for ( int i=0; greekTable[i].unicode != 0; ++i ) {
        names[TQChar( greekTable[i].unicode )] = get_name( greekTable[i] );
        entries[get_name( greekTable[i] )] = TQChar( greekTable[i].unicode );
    }
}

bool SymbolTable::contains(TQString name) const
{
    return entries.find( name ) != entries.end();
}

TQChar SymbolTable::unicode(TQString name) const
{
    return entries[ name ];
}


TQString SymbolTable::name( TQChar symbol ) const
{
    return names[symbol];
}

TQFont SymbolTable::font( TQChar symbol, const TQFont& f ) const {
    TQFontMetrics fm( f );
    if ( fm.inFont( symbol ) ) {
        return f;
    }
    return TQFont("Arev Sans");
}

CharClass SymbolTable::charClass( TQChar symbol ) const
{
    return ORDINARY;
    // FIXME
//    return entry( symbol, style ).charClass();
}


TQChar SymbolTable::unicodeFromSymbolFont( TQChar pos ) const
{
    return symbolFontHelper.unicodeFromSymbolFont( pos );
}


TQString SymbolTable::greekLetters() const
{
    return symbolFontHelper.greekLetters();
}


TQStringList SymbolTable::allNames() const
{
    TQStringList list;

    for ( int i=0; operatorTable[i].unicode != 0; ++i ) {
        list.append( get_name( operatorTable[i] ));
    }
    for ( int i=0; arrowTable[i].unicode != 0; ++i ) {
        list.append( get_name( arrowTable[i] ));
    }
    for ( int i=0; greekTable[i].unicode != 0; ++i ) {
        list.append( get_name( greekTable[i] ) );
    }
    return list;
}


TQString SymbolTable::get_name( struct UnicodeNameTable entry ) const
{
    if ( !*entry.name ) {
        return "U" + TQString( "%1" ).arg( entry.unicode, 4, 16 ).upper();
    }
    return entry.name;
}

KFORMULA_NAMESPACE_END
