/***************************************************************************
                          kwdwriter.h  -  description
                             -------------------
    begin                : Wed Sep 5 2001
    copyright            : (C) 2001 by Frank Dekervel
    email                : Frank.Dekervel@student.kuleuven.ac.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by                                                          *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWDWRITER_H
#define KWDWRITER_H


#include <tqrect.h>
#include <KoStore.h>
#include <tqdom.h>

/**
  *@author Frank Dekervel
  */


class KoTextZoomHandler;

class KWDWriter {
public: 
	KWDWriter(KoStore *store);
	~KWDWriter();


	/**
	 * writes the document to the koStore
	 **/
	bool writeDoc();


	/**
	 * adds a frameset to parent FIXME
	 **/
	TQDomElement addFrameSet(TQDomElement parent, int frametype=1,
				   int frameinfo=0, TQString name=TQString(),
				   int visible=1);

	/**
	 * \returns true if we are currently in a table (\a createTable() got called,
	 * but we are still waiting for a \a finishTable() ).
	 */
	bool isInTable() const;

	/**
	 * creates a table
	 **/
	int createTable();


	/**
	 * creates a table cell
	 **/
	TQDomElement createTableCell(int tableno, int nrow,
				int ncol, int colspan, TQRect rect);



	/**
	 * fetches the cell of a table
	 **/
	TQDomElement fetchTableCell(int tableno, int rowno, int colno);


	/**
	 * finishes a table
	 * if the arguments x,y,w,h are given, each cell is resized to have a 'right'
	 * table. otherwise, the cell sizes are not touched.
	 **/
	void finishTable(int tableno, TQRect rect);
	void finishTable(int tableno);

	/**
	 * inlines something in a paragraph
	 * @param paragraph: the paragraph the anchor should be placed in
	 * @param toInLline: the element that should be inlined
	 **/
	void createInline(TQDomElement paragraph, TQDomElement toInline);


	/**
	 * create a horizontal ruler layout
	 **/
	void createHR(TQDomElement paragraph, int width=1);

	/**
	 *
	 **/
	TQDomElement currentLayout(TQDomElement paragraph);

	/**
	 * adds a frame to frameset FIXME
	 **/
	TQDomElement addFrame(TQDomElement frameset, TQRect rect, int runaround=0, int copy=0,
                                //int top=42, int left=28, int bottom=799, int right=567,
                                int newFrameBehaviour=0, int runaroundGap=2
				);


	/**
	 * adds a paragraph
	 **/
	TQDomElement addParagraph(TQDomElement parent);
	TQDomElement addParagraph(TQDomElement parent, TQDomElement layout);

	/**
	 * adds/changes an attribute to/of the current format
	 **/
        TQDomElement formatAttribute(TQDomElement paragraph, TQString name, TQString attrName, TQString attr);

        /**
         * get a layout attribute
         **/
	TQString getLayoutAttribute(TQDomElement paragraph, TQString name, TQString attrName);


        /**
         * adds/changes an attribute to/of the current layout
         **/
        TQDomElement layoutAttribute(TQDomElement paragraph, TQString name, TQString attrName, TQString attr);

        /**
         * creates a new format in the current paragraph. do this before adding text
         * FIXME: you can only do addText once per format
         **/
        TQDomElement startFormat(TQDomElement paragraph);
        TQDomElement startFormat(TQDomElement paragraph, TQDomElement formatToClone);


	/**
	 * cleans up the current paragraph (throw away unused formats)
	 * FIXME: find a better solution
	 **/
	 void cleanUpParagraph(TQDomElement paragraph);

	/**
	 * adds some text to the current format in this paragraph
	 **/
	void addText(TQDomElement paragraph, TQString text, int format_id, bool keep_formatting=false);

	/**
	 * returns the current format
	 * if start_new_one is true, a new format will be started if needed
	 **/
	TQDomElement currentFormat(TQDomElement paragraph, bool start_new_one=false);

	/**
	 * create a Link (URL)
	 **/
	TQDomElement createLink(TQDomElement paragraph, TQString linkName, TQString hrefName);

	/**
	 * copy the given layout, and set it as layout of the given paragraph
	 **/
	TQDomElement setLayout(TQDomElement paragraph, TQDomElement layout);

	/**
	 * returns the text of this paragraph.
	 **/
	TQString getText(TQDomElement paragraph);

	/**
	 * returns the rectangle of the first frame of this frameset
	 **/
	TQRect getRect(TQDomElement frameset);

	/**
	 * returns the 'main' frameset of this document.
	 **/
        TQDomElement mainFrameset();

	/**
	 * mark document as being written by author, and having title title
	 **/
	void createDocInfo(TQString author, TQString title);

        /**
         * returns the document root
         **/
        TQDomElement docroot();

        /**
         * creates a KWord Variable (Link, ...)
         **/
	void appendKWordVariable(TQDomDocument& doc, TQDomElement& format,
		const TQString& text, const TQString& key, int type, TQDomElement& child);

private:
	/**
	 * creates a rectangle
	 **/
	void addRect(TQDomElement e, TQRect rect);

       	
protected:
	KoStore *_store;
	TQDomElement _mainFrameset;
	TQDomDocument *_doc;
	TQDomDocument *_docinfo;
	TQDomElement _docinfoMain;
	KoTextZoomHandler *_zoomhandler;
	int tableNo;
	bool insidetable;
	
};

#endif
