/* $Id$ */

#include "kchartWizardSetupDataPage.h"
#include "kchart_view.h"
#include "kchartWizard.h"

#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>

namespace KChart
{

KChartWizardSetupDataPage::KChartWizardSetupDataPage( TQWidget* parent,
                                                                                                          KChartPart* chart) :
  TQWidget( parent ),
  _chart( chart ),
  _parent( (KChartWizard*)parent )
{
  TQButtonGroup* tmpTQGroupBox;
  tmpTQGroupBox = new TQButtonGroup( this, "GroupBox_1" );
  tmpTQGroupBox->setGeometry( 260, 10, 130, 80 );
  tmpTQGroupBox->setFrameStyle( 49 );
  tmpTQGroupBox->setAlignment( 1 );

  datarow = new TQRadioButton( this, "RadioButton_1" );
  datarow->setGeometry( 270, 40, 100, 20 );
  datarow->setText( i18n("Rows") );
  connect( datarow, TQ_SIGNAL( clicked() ),
                   this, TQ_SLOT( dataInRowsClicked() ) );
  tmpTQGroupBox->insert( datarow );

  datacol = new TQRadioButton( this, "RadioButton_2" );
  datacol->setGeometry( 270, 60, 100, 20 );
  datacol->setText( i18n("Columns") );
  datacol->setChecked( true );
  connect( datarow, TQ_SIGNAL( clicked() ),
                   this, TQ_SLOT( dataInColsClicked() ) );
  tmpTQGroupBox->insert( datacol );

  TQLabel* tmpTQLabel;
  tmpTQLabel = new TQLabel( this, "Label_3" );
  tmpTQLabel->setGeometry( 270, 20, 100, 20 );
  tmpTQLabel->setText( i18n("Data is in:") );

  TQButtonGroup* descrBG = new TQButtonGroup( this );
  descrBG->hide();
  coldescript = new TQCheckBox( this, "CheckBox_3" );
  coldescript->setGeometry( 260, 110, 20, 30 );
  coldescript->setChecked( true );
  connect( coldescript, TQ_SIGNAL( toggled( bool ) ),
                   this, TQ_SLOT( firstColumnIsDescriptionToggled( bool ) ) );
  coldescript->setText( "" );
  descrBG->insert( coldescript );

  tmpTQLabel = new TQLabel( this, "Label_4" );
  tmpTQLabel->setGeometry( 280, 110, 100, 30 );
  tmpTQLabel->setText( i18n("Use first row as description") );
  tmpTQLabel->setAlignment( 1313 );

  rowdescript = new TQCheckBox( this, "CheckBox_4" );
  rowdescript->setGeometry( 260, 150, 20, 30 );
  connect( rowdescript, TQ_SIGNAL( toggled( bool ) ),
                   this, TQ_SLOT( firstRowIsDescriptionToggled( bool ) ) );
  rowdescript->setText( "" );
  descrBG->insert( rowdescript );

  tmpTQLabel = new TQLabel( this, "Label_5" );
  tmpTQLabel->setGeometry( 280, 150, 100, 30 );
  tmpTQLabel->setText( i18n("Use first column as description") );
  tmpTQLabel->setAlignment( 1313 );

  TQFrame* tmpTQFrame;
  tmpTQFrame = new TQFrame( this, "Frame_1" );
  tmpTQFrame->setGeometry( 10, 10, 240, 220 );
  tmpTQFrame->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
  tmpTQFrame->setLineWidth( 2 );

  /*
  preview = new kchartWidget( _chart, tmpTQFrame );
  preview->show();
  _chart->addAutoUpdate( preview );
  preview->resize( tmpTQFrame->contentsRect().width(),
                                   tmpTQFrame->contentsRect().height() );
  */
  //parent->resize( 400, 350 );
}


KChartWizardSetupDataPage::~KChartWizardSetupDataPage()
{
    /*
  _chart->removeAutoUpdate( preview );
    */
}


void KChartWizardSetupDataPage::dataInRowsClicked()
{
  _parent->emitNeedNewData( (const char*)_parent->dataArea().local8Bit(), KChartWizard::Row,
                                                                 coldescript->isChecked(),
                                                                 rowdescript->isChecked() );
}

void KChartWizardSetupDataPage::dataInColsClicked()
{
  _parent->emitNeedNewData( (const char*)_parent->dataArea().local8Bit(), KChartWizard::Col,
                                                        coldescript->isChecked(),
                                                        rowdescript->isChecked() );
}

void KChartWizardSetupDataPage::firstColumnIsDescriptionToggled( bool )
{
  _parent->emitNeedNewData( (const char*)_parent->dataArea().local8Bit(),
                                                        ( datarow->isChecked() ? KChartWizard::Row :
                                                          KChartWizard::Col ),
                                                        coldescript->isChecked(),
                                                        rowdescript->isChecked() );
}

void KChartWizardSetupDataPage::firstRowIsDescriptionToggled( bool )
{
  _parent->emitNeedNewData( (const char*)_parent->dataArea().local8Bit(),
			    ( datarow->isChecked() ? KChartWizard::Row 
			                           : KChartWizard::Col ),
			    coldescript->isChecked(),
			    rowdescript->isChecked() );
}

}  //namespace KChart

#include "kchartWizardSetupDataPage.moc"
