#ifndef XOSD_H_
#define XOSD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqstring.h>
#include <tqwidget.h>
#include <tqfont.h>
#include <tqpixmap.h>
#include <tqbitmap.h>

#include <netwm.h>
#include <twin.h>

class xosd : public TQWidget
{
  TQ_OBJECT
  public:
    xosd(TQWidget* parent = 0, const char* name = 0);

    virtual ~xosd();
    void setText(const TQString& t);
    void setFont(const TQString& font);
    void setItalic();
    void setBold();
    void setSize(int size);
    void setColor(const TQString& color);
    void setShadowColor(const TQString& color);
    void setShadowOffset(int off);
    void move2(int x, int y);
    void setOrientation(int orientation, int w, int mh);
    void setClear(int nClean);
    int yOffset;
    int w, h;
    int fontSize;
    int fontStyle;
    TQString fontFamily;

  private:
    NETWinInfo* info;
    TQString text;
    TQFont f;
    TQString fontColor;
    TQString shadowColor;
    int shadowOffset;
    int fOrientation;
    TQPixmap bgBuffer;
    int dw, rdh;
    int lastX, lastY;
    int fCleaner;
    TQPixmap maskBuffer;

  protected:
    void paintEvent(TQPaintEvent*);
};

#endif // XOSD_H_
