/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/


#ifndef PSQLRECIPEDB_H
#define PSQLRECIPEDB_H

#define PSQL_DRIVER "TQPSQL7"

#include "qsqlrecipedb.h"

/**
@author Jason Kivlighn
*/
class PSqlRecipeDB : public TQSqlRecipeDB
{

	TQ_OBJECT

private:
	void createDB( void );

public:
	PSqlRecipeDB( const TQString& host, const TQString& user = TQString::null, const TQString& pass = TQString::null, const TQString& DBName = DEFAULT_DB_NAME, int port = 0 );
	~PSqlRecipeDB( void );

	int lastInsertID();
	void initializeData();

	void createTable( const TQString &tableName );
	void givePermissions( const TQString &dbName, const TQString &username, const TQString &password, const TQString &clientHost );

protected:
	virtual TQString qsqlDriverPlugin() const
	{
		return PSQL_DRIVER;
	}
	virtual int getNextInsertID( const TQString &table, const TQString &column );

	virtual void empty( void );

private:
	void portOldDatabases( float version );
	TQStringList backupCommand() const;
	TQStringList restoreCommand() const;

	void addColumn( const TQString &new_table_sql, const TQString &new_col_info, const TQString &default_value, const TQString &table_name, int col_index );

	int last_insert_id;
};




#endif
