/***************************************************************************
*   Copyright (C) 2006 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef CONVERSIONDIALOG_H
#define CONVERSIONDIALOG_H

#include <kdialogbase.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class KComboBox;
class TQLabel;
class KLineEdit;
class TQPushButton;

class RecipeDB;
class UnitComboBox;
class IngredientComboBox;
class PrepMethodComboBox;
class FractionInput;

class ConversionDialog : public KDialogBase
{
TQ_OBJECT
	
public:
	ConversionDialog( TQWidget* parent, RecipeDB *, const char* name = 0 );
	~ConversionDialog();

	virtual void show();
	void reset();

protected:	
	IngredientComboBox* ingredientBox;
	PrepMethodComboBox* prepMethodBox;
	TQLabel* convertLabel;
	UnitComboBox* toUnitBox;
	UnitComboBox* fromUnitBox;
	FractionInput* amountEdit;
	TQLabel* toLabel;
	TQLabel* resultLabel;
	TQLabel* resultText;
	
protected slots:
	virtual void languageChange();
	void slotUser1();
	void convert();

private:
	RecipeDB *m_database;
};

#endif // CONVERSIONDIALOG_H
