/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef DIETVIEWDIALOG_H
#define DIETVIEWDIALOG_H

#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqvbox.h>
#include <tqwidget.h>

#include <tdehtml_part.h>
#include <tdehtmlview.h>
#include <kdialogbase.h>

#include "datablocks/recipelist.h"

class DietViewDialog: public KDialogBase
{
	TQ_OBJECT

public:
	DietViewDialog( TQWidget *parent, const RecipeList &recipeList, int dayNumber, int mealNumber, const TQValueList <int> &dishNumbers );
	~DietViewDialog();
private:
	// Widgets
	TDEHTMLPart *dietView;

	// Private methods
	void showDiet( const RecipeList &recipeList, int dayNumber, int mealNumber, const TQValueList <int> &dishNumbers );
private slots:
	void print( void );
	void slotOk( void );
signals:
	void signalOk( void );
};

#endif
