/***************************************************************************
                         helpdialog.cpp  -  description
                             -------------------
    begin                : Fr Nov 15 13:44:19 CEST 2001
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "helpdialog.h"
#include "krenameimpl.h"

// TQt includes
#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqlineedit.h>

// TDE includes
#include <tdelocale.h>
#include <tdelistview.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

void HelpDialogData::remove( const TQString & headline )
{
    if( m_map.contains( headline ) ) {
        m_map.remove( headline );
        m_icons.remove( headline );
        
        emit updateHeadline();                
        emit updateItems();
    }
}

void HelpDialogData::add( const TQString & headline, TQStringList* commands, const TQPixmap & icon, bool first )
{
    m_map.insert( headline, *commands );
    m_icons.insert( headline, icon );
    if( first )
        m_first = headline;
        
    emit updateHeadline();
    emit updateItems();
}

TQStringList HelpDialogData::tokens() const
{
    TQStringList list;

    TQStringList keys = m_map.keys();

    for( unsigned int i = 0; i < keys.count(); i++ )
        for( unsigned int z = 0; z < m_map[keys[i]].count(); z++ )
            list.append( m_map[keys[i]][z].section( ";;", 0, 0 ) );

    return list;
}


HelpDialog::HelpDialog( HelpDialogData* data, TQWidget* parent,
    const char* name, bool modal, WFlags fl )
    : TQDialog( parent, name, modal, fl )
{
    text = NULL;

    resize( 500, 400 ); 
    setCaption( i18n( "Help" ) );
    HelpDialogLayout = new TQVBoxLayout( this, 11, 6, "HelpDialogLayout"); 

    comboHeadline = new TQComboBox( false, this, "comboHeadline" );
    HelpDialogLayout->addWidget( comboHeadline );

    list = new TDEListView( this, "list" );
    list->addColumn( i18n( "Token" ) );
    list->addColumn( i18n( "Description" ) );
    HelpDialogLayout->addWidget( list );

    Layout1 = new TQHBoxLayout( 0, 0, 6, "Layout1"); 
    TQSpacerItem* spacer = new TQSpacerItem( 91, 0, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonAdd = new KPushButton( this, "buttonAdd" );
    buttonAdd->setText( i18n( "&Add" ) );
    Layout1->addWidget( buttonAdd );

    buttonClose = createButton( KStdGuiItem::close(), this );
    Layout1->addWidget( buttonClose );
    HelpDialogLayout->addLayout( Layout1 );

    // signals and slots connections
    connect( buttonClose, TQ_SIGNAL( clicked() ), this, TQ_SLOT( accept() ) );
    connect( buttonAdd, TQ_SIGNAL( clicked() ), this, TQ_SLOT( execute() ) );
    connect( list, TQ_SIGNAL( executed(TQListViewItem*) ), this, TQ_SLOT( execute() ) );
    connect( comboHeadline, TQ_SIGNAL( activated(int) ), this, TQ_SLOT(updateItems() ) );
    
    m_data = data;
    connect( m_data, TQ_SIGNAL( updateItems() ), this, TQ_SLOT( updateItems() ) );
    connect( m_data, TQ_SIGNAL( updateHeadline() ), this, TQ_SLOT( updateHeadline() ) );
}

HelpDialog::~HelpDialog()
{
    disconnect( m_data, TQ_SIGNAL( updateItems() ), this, TQ_SLOT( updateItems() ) );
    disconnect( m_data, TQ_SIGNAL( updateHeadline() ), this, TQ_SLOT( updateHeadline() ) );
}

void HelpDialog::execute()
{
    if(!list->currentItem())
        return;

    TQString t = text->text();

    t.insert( text->cursorPosition(), list->currentItem()->text( 0 ) );
    text->setText( t );
    
    if( isModal() )
        accept();
}

void HelpDialog::updateItems()
{
    list->clear();
    TQStringList items = m_data->map()[comboHeadline->currentText()];

    for( unsigned int i = 0; i < items.count(); i++ ) {
        TQString tmp = items[i];
        new TDEListViewItem( list, tmp.section( ";;", 0, 0 ), tmp.section( ";;", 1, 1 ) );
    }
}

void HelpDialog::updateHeadline()
{
    comboHeadline->clear();
    TQMap<TQString,TQStringList> m = m_data->map();
    TQMap<TQString,TQPixmap> ic = m_data->icons();
    
    comboHeadline->insertItem( ic[m_data->first()], m_data->first() );    
    TQMap<TQString, TQStringList>::Iterator it;
    for ( it = m.begin(); it != m.end(); ++it )
        if( it.key() != m_data->first() )
            comboHeadline->insertItem( ic[it.key()], it.key() );    
}

#include "helpdialog.moc"
