//=============================================================================
//
//   File : kvi_tal_iconview.cpp
//   Creation date : Mon Jan 22 2007 11:25:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVILIB__
#include "kvi_tal_iconview.h"


	KviTalIconView::KviTalIconView(TQWidget * pParent,TQt::WFlags f)
	: TQIconView(pParent,0,f)
	{
		connect(this,TQ_SIGNAL(selectionChanged(TQIconViewItem *)),this,TQ_SLOT(redirect_selectionChanged(TQIconViewItem *)));
		connect(this,TQ_SIGNAL(currentChanged(TQIconViewItem *)),this,TQ_SLOT(redirect_currentChanged(TQIconViewItem *)));
		connect(this,TQ_SIGNAL(clicked(TQIconViewItem *)),this,TQ_SLOT(redirect_clicked(TQIconViewItem *)));
		connect(this,TQ_SIGNAL(clicked(TQIconViewItem *,const TQPoint &)),this,TQ_SLOT(redirect_clicked(TQIconViewItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(pressed(TQIconViewItem *)),this,TQ_SLOT(redirect_pressed(TQIconViewItem *)));
		connect(this,TQ_SIGNAL(pressed(TQIconViewItem *,const TQPoint &)),this,TQ_SLOT(redirect_pressed(TQIconViewItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(doubleClicked(TQIconViewItem *)),this,TQ_SLOT(redirect_doubleClicked(TQIconViewItem *)));
		connect(this,TQ_SIGNAL(returnPressed(TQIconViewItem *)),this,TQ_SLOT(redirect_returnPressed(TQIconViewItem *)));
		connect(this,TQ_SIGNAL(rightButtonClicked(TQIconViewItem *,const TQPoint &)),this,TQ_SLOT(redirect_rightButtonClicked(TQIconViewItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(rightButtonPressed(TQIconViewItem *,const TQPoint &)),this,TQ_SLOT(redirect_rightButtonPressed(TQIconViewItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(mouseButtonClicked(int,TQIconViewItem *,const TQPoint &)),this,TQ_SLOT(redirect_mouseButtonClicked(int,TQIconViewItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(mouseButtonPressed(int,TQIconViewItem *,const TQPoint &)),this,TQ_SLOT(redirect_mouseButtonPressed(int,TQIconViewItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(contextMenuRequested(TQIconViewItem *,const TQPoint &)),this,TQ_SLOT(redirect_contextMenuRequested(TQIconViewItem *,const TQPoint &)));
		connect(this,TQ_SIGNAL(onItem(TQIconViewItem *)),this,TQ_SLOT(redirect_onItem(TQIconViewItem *)));
	}

	void KviTalIconView::redirect_selectionChanged(TQIconViewItem * pItem)
	{
		emit selectionChanged((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_currentChanged(TQIconViewItem * pItem)
	{
		emit currentChanged((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_clicked(TQIconViewItem * pItem)
	{
		emit clicked((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_clicked(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit clicked((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_pressed(TQIconViewItem * pItem)
	{
		emit pressed((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_pressed(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit pressed((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_doubleClicked(TQIconViewItem * pItem)
	{
		emit doubleClicked((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_returnPressed(TQIconViewItem * pItem)
	{
		emit returnPressed((KviTalIconViewItem *)pItem);
	}

	void KviTalIconView::redirect_rightButtonClicked(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit rightButtonClicked((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_rightButtonPressed(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit rightButtonPressed((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_mouseButtonClicked(int iButton,TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit mouseButtonClicked(iButton,(KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_mouseButtonPressed(int iButton,TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit mouseButtonPressed(iButton,(KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_contextMenuRequested(TQIconViewItem * pItem,const TQPoint &pnt)
	{
		emit contextMenuRequested((KviTalIconViewItem *)pItem,pnt);
	}

	void KviTalIconView::redirect_onItem(TQIconViewItem * pItem)
	{
		emit onItem((KviTalIconViewItem *)pItem);
	}


	#include "kvi_tal_iconview_qt3.moc"

