#ifndef _DIALOG_H_
#define _DIALOG_H_
//=============================================================================
//
//   File : edituser.h
//   Creation date : Sun Dec 24 2000 15:16:17 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
#include "kvi_string.h"
#include "kvi_regusersdb.h"
#include "kvi_selectors.h"

#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include "kvi_tal_listview.h"
#include "kvi_tal_listbox.h"
#include "kvi_pointerhashtable.h"
#include "kvi_tal_popupmenu.h"
	#include <tqsimplerichtext.h>
	#include <tqintdict.h>



class KviRegisteredUsersDialogItemBase : public KviTalListViewItem
{
public:
	enum Types { User,Group };
protected:
	KviRegisteredUsersDialogItemBase(Types type,KviTalListView * par)
	:KviTalListViewItem(par),m_iType(type)
	{
	};
	KviRegisteredUsersDialogItemBase(Types type,KviTalListViewItem * par)
	:KviTalListViewItem(par),m_iType(type)
	{
	};
	~KviRegisteredUsersDialogItemBase()
	{
	};
	
private:
	KviRegisteredUsersDialogItemBase::Types m_iType;
public:
	KviRegisteredUsersDialogItemBase::Types type() { return m_iType; };
};

class KviRegisteredUsersGroupItem : public KviRegisteredUsersDialogItemBase
{
protected:
	KviRegisteredUserGroup * m_pGroup;
public:
	KviRegisteredUsersGroupItem(KviTalListView * par,KviRegisteredUserGroup * g)
	:KviRegisteredUsersDialogItemBase(Group,par), m_pGroup(g)
	{
		setText(0,m_pGroup->name());
	}
	~KviRegisteredUsersGroupItem()
	{
	}
	KviRegisteredUserGroup * group() { return m_pGroup; };
};

class KviRegisteredUsersDialogItem : public KviRegisteredUsersDialogItemBase
{
protected:
	KviRegisteredUser * m_pUser;
	TQSimpleRichText * m_pText;
public:
	KviRegisteredUsersDialogItem(KviTalListViewItem * par,KviRegisteredUser * u);
	~KviRegisteredUsersDialogItem();
public:
	KviRegisteredUser * user(){ return m_pUser; };
	void setUser(KviRegisteredUser * u){ m_pUser = u; };
	virtual void paintCell(TQPainter * p,const TQColorGroup &cg,int column,int width,int align);
	virtual void setup();
	virtual TQString key(int,bool) const;
};

class KviRegisteredUsersDialog : public TQWidget
{
	TQ_OBJECT
  
public:
	KviRegisteredUsersDialog(TQWidget * par = 0);
	~KviRegisteredUsersDialog();
public:
	KviTalListView   * m_pListView;
	TQPushButton * m_pAddButton;
	TQPushButton * m_pWizardAddButton;
	TQPushButton * m_pRemoveButton;
	TQPushButton * m_pEditButton;
	TQPushButton * m_pImportButton;
	TQPushButton * m_pExportButton;
	TQPushButton * m_pAddGroupButton;
	TQIntDict<KviRegisteredUserGroup> m_TmpDict;

	protected slots:
	void itemPressed(KviTalListViewItem *it,const TQPoint &pnt,int c);
	void itemDoubleClicked(KviTalListViewItem *it);
protected:
	void fillList();
protected:
	virtual void closeEvent(TQCloseEvent *);
	void editItem(KviRegisteredUsersDialogItem * i);
	void editGroup(KviRegisteredUserGroup* group);
protected slots:
	void cancelClicked();
	void okClicked();
	void addClicked();
	void removeClicked();
	void editClicked();
	void selectionChanged();
	void importClicked();
	void exportClicked();
	void addWizardClicked();
	void addGroupClicked();
	void listViewRightButtonClicked ( KviTalListViewItem *, const TQPoint &, int );
	void moveToGroupMenuClicked(int);
};

#endif
