/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <knuminput.h>
#include <tdeactionselector.h>
#include <tqlistbox.h>
#include <kpushbutton.h>
#include <tqpixmap.h>
#include <tqiconset.h>
#include <tqlabel.h>
#include <kpassdlg.h>

#include "ldapchgpassdlg.h"
#include "ldapchgpasswddlg.h"

LDAPChangePasswordDialog::LDAPChangePasswordDialog(TQWidget* parent, const char* name, bool allowGSSAPI, bool allowSmartCard)
	: KDialogBase(parent, name, true, i18n("LDAP Authentication"), Ok|Cancel|((allowGSSAPI)?User1:0)|((allowSmartCard)?User2:0), Ok, true, i18n("Authenticate with SASL/GSSAPI"), i18n("Authenticate with cryptographic card"))
{
	m_base = new LDAPChangePassword(this);

	connect(m_base->ldapUsername, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(processLockouts()));
	connect(m_base->ldapCurrentPassword, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(processLockouts()));
	connect(m_base->ldapNewPassword, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(processLockouts()));
	connect(m_base->ldapConfirmNewPassword, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(processLockouts()));

	setMainWidget(m_base);
	processLockouts();
}

void LDAPChangePasswordDialog::slotOk() {
	use_gssapi = false;
	use_smartcard = false;
	accept();
}

void LDAPChangePasswordDialog::slotUser1() {
	use_gssapi = true;
	use_smartcard = false;
	accept();
}

void LDAPChangePasswordDialog::slotUser2() {
	use_gssapi = false;
	use_smartcard = true;
	accept();
}

void LDAPChangePasswordDialog::processLockouts() {
	bool dataValid = true;

	if (m_base->ldapUsername->text().length() < 1)
		dataValid = false;
	if (m_base->ldapCurrentPassword->password().length() < 1)
		dataValid = false;
	if (m_base->ldapNewPassword->password().length() < 1)
		dataValid = false;
	if (m_base->ldapNewPassword->password() == m_base->ldapCurrentPassword->password())
		dataValid = false;
	if (m_base->ldapNewPassword->password() != m_base->ldapConfirmNewPassword->password())
		dataValid = false;

	enableButtonOK(dataValid);
}

#include "ldapchgpasswddlg.moc"
