/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PIC_PROTECTION_H
#define PIC_PROTECTION_H

#include "pic.h"

namespace Pic
{
class Data;

//----------------------------------------------------------------------------
class Protection
{
public:
  enum { MAX_NB_BLOCKS = 8 };
  enum Family { NoProtection = 0, BasicProtection, BlockProtection, CodeGuard, Nb_Families };
  enum Type { ProgramProtected = 0, WriteProtected, ReadProtected,
              StandardSecurity, HighSecurity, Nb_Types };

public:
  Protection(const Pic::Data &data, const Config &config) : _data(data), _config(config) {}
  Family family() const;
  TQString securityValueName(Type type) const;
  bool hasBootBlock() const;
  TQString bootSizeMaskName() const;
  TQString bootMaskName(Type ptype) const;
  TQString bootLabel() const;
  uint nbBlocks() const;
  TQString blockSizeMaskName(uint i) const;
  TQString blockMaskName(Type ptype, uint i) const;
  TQString blockLabel(uint i) const;
  AddressRangeVector extractRanges(const TQString &name, MemoryRangeType type) const;
  bool checkRange(const TQString &mask, const TQString &name) const;
  TQString maskName(Type type, MemoryRangeType mtype) const;
  bool isAllProtectedValueName(const TQString &valueName) const;
  bool isNoneProtectedValueName(const TQString &valueName) const;

private:
  const Pic::Data &_data;
  const Config    &_config;

  enum SegmentType { BootSegment = 0, SecureSegment, GeneralSegment, Nb_SegmentTypes };
  static bool extractRanges(const TQString &name, TQValueVector<Address> &starts, Address &end, bool &ok);
  class ProtectedRange {
  public:
    TQValueVector<Address> starts, ends;
  };
  ProtectedRange extractRange(const TQString &mask, const TQString &name, bool &ok) const;
};

} //namespace

#endif
