/* This file is part of the KDE project
   Copyright (C) 2005 Daniel Teske <teske@squorn.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License version 2 as published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "kebsearchline.h"
#include "kebsearchline.moc"

KEBSearchLine::KEBSearchLine(TQWidget *parent, TDEListView *listView, const char *name)
    : TDEListViewSearchLine(parent, listView, name)
{
    mmode = AND;
}

KEBSearchLine::KEBSearchLine(TQWidget *parent, const char *name)
    :TDEListViewSearchLine(parent, name)
{
    mmode = AND;
}

void KEBSearchLine::updateSearch(const TQString &s)
{
    TDEListViewSearchLine::updateSearch(s);
    emit searchUpdated();
}

KEBSearchLine::~KEBSearchLine()
{
}

bool KEBSearchLine::itemMatches(const TQListViewItem *item, const TQString &s) const
{
    if(mmode == EXACTLY)
       return TDEListViewSearchLine::itemMatches(item, s);

    if(lastpattern != s)
    {
       splitted = TQStringList::split(TQChar(' '), s);
       lastpattern = s;
    }

    TQStringList::const_iterator it = splitted.begin();
    TQStringList::const_iterator end = splitted.end();

    if(mmode == OR)
    {
       if(it == end) //Nothing to match
           return true;
       for( ; it != end; ++it)
           if(TDEListViewSearchLine::itemMatches(item, *it))
               return true;
    }
    else if(mmode == AND)
       for( ; it != end; ++it)
           if(! TDEListViewSearchLine::itemMatches(item, *it))
               return false;

    return (mmode == AND);
}

KEBSearchLine::modes KEBSearchLine::mode()
{
    return mmode;
}

void KEBSearchLine::setMode(modes m)
{
    mmode = m;
}
