/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;
import java.text.*;

class TabDialog  extends TQTabDialog
{

protected String filename;
protected TQFileInfo fileinfo;


TabDialog( TQWidget parent, String name, String _filename )
{
    super( parent, name );
	filename = _filename;
	fileinfo = new TQFileInfo(filename);
    setupTab1();
    setupTab2();
    setupTab3();

    connect( this, TQ_SIGNAL(" applyButtonPressed()"), tqApp(), TQ_SLOT(" quit()") );
}

void setupTab1()
{
    TQVBox tab1 = new TQVBox( this );
    tab1.setMargin( 5 );

    new TQLabel( "Filename:", tab1 );
    TQLineEdit fname = new TQLineEdit( filename, tab1 );
    fname.setFocus();

    new TQLabel( "Path:", tab1 );
    TQLabel path = new TQLabel( fileinfo.dirPath( true ), tab1 );
    path.setFrameStyle( TQFrame.Panel | TQFrame.Sunken );

    new TQLabel( "Size:", tab1 );
    TQLabel size = new TQLabel( fileinfo.size() + " KB", tab1 );
    size.setFrameStyle( TQFrame.Panel | TQFrame.Sunken );

	SimpleDateFormat dateFormat = new SimpleDateFormat("EE MMM d hh:mm:ss yyyy");

    new TQLabel( "Last Read:", tab1 );
    TQLabel lread = new TQLabel( dateFormat.format(fileinfo.lastRead().getTime()), tab1 );
    lread.setFrameStyle( TQFrame.Panel | TQFrame.Sunken );

    new TQLabel( "Last Modified:", tab1 );
    TQLabel lmodif = new TQLabel( dateFormat.format(fileinfo.lastModified().getTime()), tab1 );
    lmodif.setFrameStyle( TQFrame.Panel | TQFrame.Sunken );

    addTab( tab1, "General" );
}

void setupTab2()
{
    TQVBox tab2 = new TQVBox( this );
    tab2.setMargin( 5 );

    TQButtonGroup bg = new TQButtonGroup( 1, TQGroupBox.Horizontal, "Permissions", tab2 );

    TQCheckBox readable = new TQCheckBox( "Readable", bg );
    if ( fileinfo.isReadable() )
        readable.setChecked( true );

    TQCheckBox writable = new TQCheckBox( "Writeable", bg );
    if ( fileinfo.isWritable() )
        writable.setChecked( true );

    TQCheckBox executable = new TQCheckBox( "Executable", bg );
    if ( fileinfo.isExecutable() )
        executable.setChecked( true );

    TQButtonGroup bg2 = new TQButtonGroup( 2, TQGroupBox.Horizontal, "Owner", tab2 );

    new TQLabel( "Owner", bg2 );
    TQLabel owner = new TQLabel( fileinfo.owner(), bg2 );
    owner.setFrameStyle( TQFrame.Panel | TQFrame.Sunken );

    new TQLabel( "Group", bg2 );
    TQLabel group = new TQLabel( fileinfo.group(), bg2 );
    group.setFrameStyle( TQFrame.Panel | TQFrame.Sunken );

    addTab( tab2, "Permissions" );
}

void setupTab3()
{
    TQVBox tab3 = new TQVBox( this );
    tab3.setMargin( 5 );
    tab3.setSpacing( 5 );
    
    new TQLabel( "Open " + filename + " with:", tab3 );

    TQListBox prgs = new TQListBox( tab3 );
    for ( int i = 0; i < 30; i++ ) {
        String prg = "Application " + i;
        prgs.insertItem( prg );
    }
    prgs.setCurrentItem( 3 );

    new TQCheckBox( "Open files with the extension '" + fileinfo.extension() + "' always with this application", tab3 );

    addTab( tab3, "Applications" );
}
}
