//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQObject;
import org.trinitydesktop.qt.TQObject;

/**

 Inter-process communication and remote procedure calls
 for KDE applications.
 This class provides IPC and RPC for KDE applications.  Usually you
 will not have to instantiate one yourself because TDEApplication
 contains a method to return a pointer to a DCOPClient object which
 can be used for your whole application.
 Before being able to send or receive any DCOP messages, you will have
 to attach your client object to the DCOP server, and then register
 your application with a specific name. See attach()
 and registerAs() for
 more information.
 Data to be sent should be serialized into a TQDataStream which was
 initialized with the byte[] that you actually intend to send
 the data in.  An example of how you might do this:
 <pre>
   byte[] data;
   TQDataStream arg(data, IO_WriteOnly);
   arg << String("This is text I am serializing");
   client.send("someApp", "someObject", "someFunction(String)", data);
 </pre>
 See {@link DCOPClientSignals} for signals emitted by DCOPClient
		@author Preston Brown <pbrown@kde.org>, Matthias Ettrich <ettrich@kde.org>

		@short    Inter-process communication and remote procedure calls  for KDE applications.
		@see TDEApplication#dcopClient

*/
public class DCOPClient extends TQObject  {
	protected DCOPClient(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructs a new DCOP client, but does not attach to any server.  		@short    Constructs a new DCOP client, but does not attach to any server.
	*/
	public DCOPClient() {
		super((Class) null);
		newDCOPClient();
	}
	private native void newDCOPClient();
	/**
		 Attaches to the DCOP server.
			 If the connection was already attached,
		 the connection will be re-established with the current server address.
			 Naturally, only attached application can use DCOP services.
			 If a TQApplication object exists then client registers itself as
		 TQApplication.name() + "-" + \<pid\>.
		 If no TQApplication object exists the client registers itself as
		 "anonymous".
			 If you want to register differently, you should use registerAs()
		 instead.
				@return true if attaching was successful.

		@short    Attaches to the DCOP server.
	*/
	public native boolean attach();
	/**
			 Internal function for TDEUniqueApplication to register the DCOPClient
		 with the application in case the application didn't exist at the
		 time the DCOPClient was created.
		   		@short
	*/
	public native void bindToApp();
	/**
		 Detaches from the DCOP server.
				@return true if successful, false otherwise

		@short    Detaches from the DCOP server.
	*/
	public native boolean detach();
	/**
		 Returns whether or not the client is attached to the server.
				@return true if attached, false if not

		@short    Returns whether or not the client is attached to the server.
	*/
	public native boolean isAttached();
	/**
		 Returns whether the client is attached to a server owned by
		 another user.
				@return true if attached to a foreign server, false if not

		@short    Returns whether the client is attached to a server owned by  another user.
	*/
	public native boolean isAttachedToForeignServer();
	/**
		 Returns whether the client handles incoming calls.
				@return true if the client accepts calls

		@short    Returns whether the client handles incoming calls.
	*/
	public native boolean acceptCalls();
	/**
		 Specify whether the client should accept incoming calls.
		 By default clients accept incoming calls, but not when connected
		 to a foreign server.
			@param b true to accept calls, false to reject them
		   		@short    Specify whether the client should accept incoming calls.
	*/
	public native void setAcceptCalls(boolean b);
	/**
		 Returns whether the DCOP - Qt bridge is enabled.
		 By default the DCOP - Qt bridge is enabled.
				@return true if Qt objects are accessible over DCOP

		@short    Returns whether the DCOP - Qt bridge is enabled.
	*/
	public native boolean qtBridgeEnabled();
	/**
		 Specify whether Qt objects of the application should be accessible
		 via DCOP.
		 By default the DCOP - Qt bridge is enabled.
			@param b true to make Qt objects accessible over DCOP
				@short    Specify whether Qt objects of the application should be accessible  via DCOP.
	*/
	public native void setQtBridgeEnabled(boolean b);
	/**
		 Registers at the DCOP server.
			 If the application was already registered,
		 the registration will be re-done with the new appId.
			 <code>appId</code> is a <code>unique</code> application/program id that the server
		 will use to associate requests with. If there is already an application
		 registered with the same name, the server will add a number to the
		 id to unify it. If <code>addPID</code> is true, the PID of the current process
		 will be added to id.
			 Registration is necessary if you want to allow other clients to talk
		 to you.  They can do so using your <code>appId</code> as first parameter
		 for send() or call(). If you just want to talk to
		  other clients, you
		 do not need to register at the server. In that case attach() is
		 enough.
		 It will implicitly register you as "anonymous".
			@param appId the id of the application
			@param addPID true to add the process id
				@return The actual <code>appId</code> used for the registration or a null string
 if the registration wasn't successful.

		@short    Registers at the DCOP server.
	*/
	public native String registerAs(String appId, boolean addPID);
	public native String registerAs(String appId);
	/**
		 Returns whether or not the client is registered at the server.
				@return true if registered at the server

		@short    Returns whether or not the client is registered at the server.
	*/
	public native boolean isRegistered();
	/**
		 Returns the current app id or a null string if the application
		 hasn't yet been registered.
				@return the application id, or null if not registered

		@short    Returns the current app id or a null string if the application  hasn't yet been registered.
	*/
	public native String appId();
	/**
		 Returns the socket fd that is used for communication with the server.
				@return The socket over which DCOP is communicating with the server.

		@short    Returns the socket fd that is used for communication with the server.
	*/
	public native int socket();
	/**
		 Temporarily suspends processing of DCOP events.
		 This can be useful if you need to show e.g. a dialog before
		 your application is ready to accept DCOP requests. Normally the
		 dialog would start an event loop and in this event loop DCOP
		 requests will be handled.
			 Be aware that not responding to DCOP requests may cause other
		 programs that want to communicate with your application, to hang.
				@short    Temporarily suspends processing of DCOP events.
		@see #resume
		@see #isSuspended
	*/
	public native void suspend();
	/**
		 Resumes the processing of DCOP events.
				@short    Resumes the processing of DCOP events.
		@see #suspend#
		@see #isSuspended
	*/
	public native void resume();
	/**
		 Returns whether DCOP events are being processed.
				@short    Returns whether DCOP events are being processed.
		@see #suspend
		@see #resume#
	*/
	public native boolean isSuspended();
	/**
		 Sends a data block to the server.
			@param remApp The remote application id.
			@param remObj The name of the remote object.
			@param remFun The remote function in the specified object to call.
			@param data The data to provide to the remote function.
				@return Whether or not the server was able to accept the send.

		@short    Sends a data block to the server.
	*/
	public native boolean send(String remApp, String remObj, String remFun, byte[] data);
	/**
		 This function acts exactly the same as the above, but the data
		 parameter can be specified as a String for convenience.
			@param remApp The remote application id.
			@param remObj The name of the remote object.
			@param remFun The remote function in the specified object to call.
			@param data The data to provide to the remote function.
				@return Whether or not the server was able to accept the send.

		@short    This function acts exactly the same as the above, but the data  parameter can be specified as a String for convenience.
	*/
	public native boolean send(String remApp, String remObj, String remFun, String data);
	/**
		 Performs a synchronous send and receive.
			  The parameters are the same as for send, with the exception of
		  another byte[] being provided for results to be
		  (optionally) returned in.
			 A call blocks the application until the process receives the
		 answer.
			 If <code>useEventLoop</code> is true, a local event loop will be started after
		 1/10th of a second in order to keep the user interface updated
		 (by processing paint events and such) until an answer is received.
			@param remApp the remote application's id
			@param remObj the remote object id
			@param remFun the remote function id
			@param data the data to send
			@param replyType the type of the reply will be written here
			@param replyData the data of the reply will be written here
			@param useEventLoop if true the event loop will be started when
		         the call blocks too long
			@param timeout timeout for the call in miliseconds, or -1 for no timeout
				@return true if successful, false otherwise

		@short    Performs a synchronous send and receive.
		@see #send
	*/
	public native boolean call(String remApp, String remObj, String remFun, byte[] data, StringBuffer replyType, byte[] replyData, boolean useEventLoop, int timeout);
	/**
		 Performs a asynchronous send with receive callback.
			  The first four parameters are the same as for send.
			 <code>callBackObj</code> and <code>callBackSlot</code> specify a call back
		 slot that is called when an answer is received.
			 The slot should have the following signature:
		 callBackSlot(int callId, String replyType,
		              const byte[] &replyData);
			@param remApp the remote application's id
			@param remObj the remote object id
			@param remFun the remote function id
			@param data the data to send
			@param callBackObj object to call back
			@param callBackSlot slot to call back
				@return 0 on failure, on success a callId > 0 is
 returned that will be passed as first argument of
 the result call back

		@short    Performs a asynchronous send with receive callback.
		@see #send
		@see #callback
	*/
	public native int callAsync(String remApp, String remObj, String remFun, byte[] data, TQObject callBackObj, String callBackSlot);
	/**
		 Searches for an object which matches a criteria.
			 findObject calls <code>remFun</code> in the applications and objects identified
		 by <code>remApp</code> and <code>remObj</code> until <code>remFun</code> returns true. The name of
		 the application and object that returned true are returned in
		 <code>foundApp</code> and <code>foundObj</code> respectively.
			 If <code>remFun</code> is empty a default function is called in the object
		 which always returns <code>true.</code>
			 A findObject blocks the application until the process receives the
		 answer.
			 If <code>useEventLoop</code> is true, a local event loop will be started after
		 1/10th of a second in order to keep the user interface updated
		 (by processing paint events and such) until an answer is received.
			@param remApp The remote application id.
			@param remObj The name of the remote object.
			@param remFun The remote function in the specified object to call.
		               This function should return a boolean and is used as
		               criteria.
			@param data The data to provide to the remote function.
			@param foundApp The remote application id that matched the criteria.
			@param foundObj The remote object that matched the criteria.
			@param useEventLoop if true the event loop will be started when
		         the call blocks too long
			@param timeout timeout for the call in miliseconds, or -1 for no timeout
				@return true is returned when an object was found for which <code>remFun</code>
         returned true. If no such object is the function returns false.

		@short    Searches for an object which matches a criteria.
		@see #send
	*/
	public native boolean findObject(String remApp, String remObj, String remFun, byte[] data, StringBuffer foundApp, StringBuffer foundObj, boolean useEventLoop, int timeout);
	/**
		 Emits <code>signal</code> as DCOP signal from object <code>object</code> with <code>data</code> as
		 arguments.
		   		@short    Emits <code>signal</code> as DCOP signal from object <code>object</code> with <code>data</code> as  arguments.
	*/
	public native void emitDCOPSignal(String object, String signal, byte[] data);
	public native void emitDCOPSignal(String signal, byte[] data);
	/**
		 Connects to a DCOP signal.
			@param sender the name of the client that emits the signal. When empty
		 the signal will be passed from any client.
			@param senderObj the name of the sending object that emits the signal.
			@param signal the name of the signal. The arguments should match with slot.
			@param receiverObj The name of the object to call
			@param slot The name of the slot to call. Its arguments should match with signal.
			@param Volatile If true, the connection will not be reestablished when
		 <code>sender</code> unregisters and reregisters with DCOP. In this case the <code>sender</code>
		 must be registered when the connection is made.
		 If false, the connection will be reestablished when <code>sender</code> reregisters.
		 In this case the connection can be made even if <code>sender</code> is not registered
		 at that time.

			<li>
			<code>Volatile</code> is true and <code>sender</code>  does not exist.
			</li>

			<li>
			<code>signal</code> and <code>slot</code> do not have matching arguments.

			</li>		@return false if a connection could not be established.
 This will be the case when

		@short    Connects to a DCOP signal.
	*/
	public native boolean connectDCOPSignal(String sender, String senderObj, String signal, String receiverObj, String slot, boolean Volatile);
	/**
		 Disconnects a DCOP signal.
			 A special case is when both <code>sender</code> & <code>signal</code> are empty. In this
		 case all connections related to <code>receiverObj</code> in the current client
		 are disconnected. (Both connections from as well as to this object!)
			@param sender the name of the client that emits the signal.
			@param senderObj the name of the object that emits the signal.
		 If empty all objects will be disconnected.
			@param signal the name of the signal. The arguments should match with slot.
			@param receiverObj The name of the object the signal is connected to.
		 If empty all objects will be disconnected.
			@param slot The name of the slot the signal is connected to.
		 If empty all slots will be disconnected.
				@return false if no connection(s) where removed.

		@short    Disconnects a DCOP signal.
	*/
	public native boolean disconnectDCOPSignal(String sender, String senderObj, String signal, String receiverObj, String slot);
	/**
		 Reimplement this function to handle app-wide function calls unassociated w/an object.
			 Note that <code>fun</code> is normalized. See normalizeFunctionSignature().
			 If you do not want to reimplement this function for whatever reason,
		 you can also use a default object  or a DCOPObjectProxy.
			@param fun the normalized function signature
			@param data the received data
			@param replyType write the reply type in this string
			@param replyData write the reply data in this array
				@return true if successful, false otherwise

		@short    Reimplement this function to handle app-wide function calls unassociated w/an object.
		@see #setDefaultObject
	*/
	public native boolean process(String fun, byte[] data, StringBuffer replyType, byte[] replyData);
	/**
		 Delays the reply of the current function call
		 until endTransaction() is called.
			 This allows a server to queue requests.
			 Note: Should be called from inside process() only!
				@short    Delays the reply of the current function call  until endTransaction() is called.
		@see #endTransaction
	*/
	// DCOPClientTransaction* beginTransaction(); >>>> NOT CONVERTED
	/**
		 Sends the delayed reply of a function call.
			@param t the transaction as received from beginTransaction()
			@param replyType write the reply type in this string
			@param replyData write the reply data in this array
				@short    Sends the delayed reply of a function call.
		@see #beginTransaction
	*/
	// void endTransaction(DCOPClientTransaction* arg1,TQCString& arg2,TQByteArray& arg3); >>>> NOT CONVERTED
	/**
		 Test whether the current function call is delayed.
			 Note: Should be called from inside process() only!
				@return The ID of the current transaction or
         0 if no transaction is going on.

		@short    Test whether the current function call is delayed.
		@see #process
		@see #beginTransaction
	*/
	public native int transactionId();
	/**
		 Checks whether <code>remApp</code> is registered with the DCOP server.
			@param remApp the id of the remote application
				@return true if the remote application is registered, otherwise <code>false.</code>

		@short    Checks whether <code>remApp</code> is registered with the DCOP server.
	*/
	public native boolean isApplicationRegistered(String remApp);
	/**
		 Retrieves the list of all currently registered applications
		 from dcopserver.
				@return a list of all regietered applications

		@short    Retrieves the list of all currently registered applications  from dcopserver.
	*/
	public native ArrayList registeredApplications();
	/**
		 Retrieves the list of objects of the remote application <code>remApp.</code>
			@param remApp he id of the application
			@param ok if not null, the function sets <code>ok</code> to true if successful
		           and false if an error occurred
				@return the list of object ids

		@short    Retrieves the list of objects of the remote application <code>remApp.</code>
	*/
	public native ArrayList remoteObjects(String remApp, boolean[] ok);
	public native ArrayList remoteObjects(String remApp);
	/**
		 Retrieves the list of interfaces of the remote object <code>remObj</code>
		 of application <code>remApp.</code>
			@param remApp the id of the application
			@param remObj the id of the object
			@param ok if not null, the function sets <code>ok</code> to true if successful
		           and false if an error occurred
				@return the list of interfaces

		@short    Retrieves the list of interfaces of the remote object <code>remObj</code>  of application <code>remApp.</code>
	*/
	public native ArrayList remoteInterfaces(String remApp, String remObj, boolean[] ok);
	public native ArrayList remoteInterfaces(String remApp, String remObj);
	/**
		 Retrieves the list of functions of the remote object <code>remObj</code>
		 of application <code>remApp</code>
			@param remApp the id of the application
			@param remObj the id of the object
			@param ok if not null, the function sets <code>ok</code> to true if successful
		           and false if an error occurred
				@return the list of function ids

		@short    Retrieves the list of functions of the remote object <code>remObj</code>  of application <code>remApp</code>
	*/
	public native ArrayList remoteFunctions(String remApp, String remObj, boolean[] ok);
	public native ArrayList remoteFunctions(String remApp, String remObj);
	/**
			 Receives a DCOPSend or DCOPCall message from the server.
			@param app The application the message was intended for.  Should be
		        equal to our appId that we passed when the DCOPClient was
		        created.
			@param obj The name of the object to pass the data on to.
			@param fun The name of the function in the object to call.
			@param data The arguments for the function.
			@param replyType write the reply type in this string
			@param replyData write the reply data in this array
				@return true if successful, false otherwise

		@short
	*/
	public native boolean receive(String app, String arg2, String fun, byte[] data, StringBuffer replyType, byte[] replyData);
	/**
			 Receives a <code>DCOPFind</code> message from the server.
			@param app The application the message was intended for.  Should be
		        equal to our appId that we passed when the DCOPClient was
		        created.
			@param obj The name of the object to pass the data on to.
			@param fun The name of the function in the object to call.
			@param data The arguments for the function.
			@param replyType write the reply type in this string
			@param replyData write the reply data in this array
		   		@short
	*/
	public native boolean find(String app, String arg2, String fun, byte[] data, StringBuffer replyType, byte[] replyData);
	/**
		 Returns the appId of the last application that talked to us.
				@return the application id of the last application that send a message
         to this client

		@short    Returns the appId of the last application that talked to us.
	*/
	public native String senderId();
	/**
		 Installs object <code>objId</code> as application-wide default object.
			 All app-wide messages that have not been processed by the dcopclient
		 will be send further to <code>objId.</code>
			@param objId the id of the new default object
		    		@short    Installs object <code>objId</code> as application-wide default object.
	*/
	public native void setDefaultObject(String objId);
	/**
		 Returns the current default object or an empty string if no object is
		 installed as default object.
			 A default object receives application-wide messages that have not
		 been processed by the DCOPClient itself.
				@return the id of the new default object

		@short    Returns the current default object or an empty string if no object is  installed as default object.
	*/
	public native String defaultObject();
	/**
		 Enables / disables the applicationRegistered() /
		 applicationRemoved() signals.
		 Note that a counter is maintained about how often this method
		 was called. If this method is called twice with <code>enabled</code> set to
		 true, notifications will be enabled until it was called with
		 <code>enabled</code> set to false as often.
			 They are disabled by default.
			@param enabled true to enable notifications, false to disable
		   		@short    Enables / disables the applicationRegistered() /  applicationRemoved() signals.
	*/
	public native void setNotifications(boolean enabled);
	/**
		 Tells the dcopserver to treat the client as daemon client, not
		 as regular client.
		 If the number of regular clients drops down to zero, the
		 dcopserver will emit a KDE termination signal after 10
		 seconds.
			@param daemonMode true to enable daemon mode, false to disable
		   		@short    Tells the dcopserver to treat the client as daemon client, not  as regular client.
	*/
	public native void setDaemonMode(boolean daemonMode);
	/**
			 Switch to priority call mode.
		   		@short
	*/
	public native void setPriorityCall(boolean arg1);
	/**
				@short
	*/
	// void handleAsyncReply(DCOPClient::ReplyStruct* arg1); >>>> NOT CONVERTED
	/**
		 Sets the address of a server to use upon attaching.
			 If no server address is ever specified, attach will try its best to
		 find the server anyway.
			@param addr the new address of the server
		   		@short    Sets the address of a server to use upon attaching.
	*/
	public static native void setServerAddress(String addr);
	/**
		 Normalizes the function signature <code>fun.</code>
			 A normalized signature doesn't contain any unnecessary whitespace
		 anymore. The remaining whitespace consists of single blanks only (0x20).
			 Example for a normalized signature:
		 <pre>
		   "someFunction(String,int)"
		 </pre>
			 When using send() or call(), normalization is done
		 automatically for you.
			@param fun the function signature to normalize
				@return the normalized function

		@short    Normalizes the function signature <code>fun.</code>
	*/
	public static native String normalizeFunctionSignature(String fun);
	/**
		 Returns the application's main dcop client. The main client can
		 be used by objects that do not have any specific access to a dcop
		 client. In KDE applications, the main client usually is the same
		 as TDEApplication.dcopClient().
				@return the application's main dcop client

		@short    Returns the application's main dcop client.
	*/
	public static native DCOPClient mainClient();
	/**
		 Sets the application's main dcop client. The main client can
		 be used by objects that do not have any specific access to a dcop
		 client. In KDE applications, the main client usually is the same
		 as TDEApplication.dcopClient().
			@param mainClient the new main dcop client
		   		@short    Sets the application's main dcop client.
	*/
	public static native void setMainClient(DCOPClient mainClient);
	/**
		 Look for the given client only in this process. This can be used
		 to check whether a given client (by name) is running in the same
		 process or in another one.
		   		@short    Look for the given client only in this process.
	*/
	public static native DCOPClient findLocalClient(String _appId);
	/**
			    		@short
	*/
	public static native void emergencyClose();
	/**
			 Provides information about the last DCOP call for debugging purposes.
		    		@short
	*/
	public static native String postMortemSender();
	/**	 @internal 		@short   @internal
	*/
	public static native String postMortemObject();
	/**	 @internal 		@short   @internal
	*/
	public static native String postMortemFunction();
	/**
		 File with information how to reach the dcopserver.
			@param hostname Hostname to use, if empty current hostname of
		 the system is used.
				@return Filename that contains information how to contact the
 DCOPserver.

		@short    File with information how to reach the dcopserver.
	*/
	public static native String dcopServerFile(String hostname);
	public static native String dcopServerFile();
	/**
		 Return the path of iceauth or an empty string if not found.
		   		@short    Return the path of iceauth or an empty string if not found.
	*/
	public static native String iceauthPath();
	/**
		 Process data from the socket.
			@param socknum the fd of the socket
		   		@short    Process data from the socket.
	*/
	protected native void processSocketData(int socknum);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
