//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;

/**

 Abstract base class for KDE configuration file loading/saving.
 This class forms the base for all classes that implement some
 manner of loading/saving to configuration files.  It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. As of right now, the only back end available
 is one to read/write to INI-style files, but in the future, other
 formats may be available, such as XML or a database.
		@author Preston Brown <pbrown@kde.org>,
         Matthias Kalle Dalheimer <kalle@kde.org>

		@short KDE Configuration file loading/saving abstract base class.

*/
public class TDEConfigBackEnd implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected TDEConfigBackEnd(Class dummy){}

	/**
		 Constructs a configuration back end.
			@param _config Specifies the configuration object which values
		        will be passed to as they are read, or from where values
		        to be written to will be obtained from.
			@param _fileName The name of the file in which config
		        data is stored.  All registered configuration directories
		        will be looked in in order of decreasing relevance.
			@param _resType the resource type of the fileName specified, _if_
		        it is not an absolute path (otherwise this parameter is ignored).
			@param _useKDEGlobals If true, the user's system-wide kdeglobals file
		        will be imported into the config object.  If false, only
		        the filename specified will be dealt with.
		   		@short    Constructs a configuration back end.
	*/
	/**
		 Parses all configuration files for a configuration object.  This
		 method must be reimplemented by the derived classes.
				@return Whether or not parsing was successful.

		@short    Parses all configuration files for a configuration object.
	*/
	public native boolean parseConfigFiles();
	/**
		 Writes configuration data to file(s).  This method must be
		 reimplemented by the derived classes.
			@param bMerge Specifies whether the old config file already
		        on disk should be merged in with the data in memory.  If true,
		        data is read off the disk and merged.  If false, the on-disk
		        file is removed and only in-memory data is written out.
		   		@short    Writes configuration data to file(s).
	*/
	public native void sync(boolean bMerge);
	public native void sync();
	/**
		 Changes the filenames associated with this back end.  You should
		 probably reparse your config info after doing this.
			@param _fileName the new filename to use
			@param _resType the resource type of the fileName specified, _if_
		        it is not an absolute path (otherwise this parameter is ignored).
			@param _useKDEGlobals specifies whether or not to also parse the
		        global KDE configuration files.
		   		@short    Changes the filenames associated with this back end.
	*/
	public native void changeFileName(String _fileName, String _resType, boolean _useKDEGlobals);
	/**
		 Returns the state of the app-config object.
				@short    Returns the state of the app-config object.
		@see TDEConfig#getConfigState
	*/
	public native int getConfigState();
	/**
		 Returns the filename as passed to the constructor.
				@return the filename as passed to the constructor.

		@short    Returns the filename as passed to the constructor.
	*/
	public native String fileName();
	/**
		 Returns the resource type as passed to the constructor.
				@return the resource type as passed to the constructor.

		@short    Returns the resource type as passed to the constructor.
	*/
	public native String resource();
	/**
		 Set the locale string that defines the current language.
			@param _localeString the identifier of the language
				@short    Set the locale string that defines the current language.
		@see TDELocale
	*/
	public native void setLocaleString(String _localeString);
	/**
		 Set the file mode for newly created files.
			@param mode the filemode (as in chmod)
		   		@short    Set the file mode for newly created files.
	*/
	public native void setFileWriteMode(int mode);
	/**
		 Check whether the config files are writable.
			@param warnUser Warn the user if the configuration files are not writable.
				@return Indicates that all of the configuration files used are writable.

		@short    Check whether the config files are writable.
	*/
	public native boolean checkConfigFilesWritable(boolean warnUser);
	/**
		 Returns a lock file object for the configuration file
			@param bGlobal If true, returns a lock file object for kdeglobals
				@short    Returns a lock file object for the configuration file
	*/
	// TDELockFile::Ptr lockFile(bool arg1); >>>> NOT CONVERTED
	// TDELockFile::Ptr lockFile(); >>>> NOT CONVERTED
}
