//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import java.util.Calendar;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQTextCodec;
import java.util.Date;

/**

 TDELocale provides support for country specific stuff like
 the national language.
 TDELocale supports translating, as well as specifying the format
 for numbers, currency, time, and date.
		@author Stephan Kulow <coolo@kde.org>, Preston Brown <pbrown@kde.org>,
 Hans Petter Bieker <bieker@kde.org>, Lukas Tinkl <lukas.tinkl@suse.cz>

		@short class for supporting locale settings and national language.

*/
public class TDELocale implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected TDELocale(Class dummy){}

	/**
		 Various positions for where to place the positive or negative
		 sign when they are related to a monetary value.
		   		@short    Various positions for where to place the positive or negative  sign when they are related to a monetary value.
	*/
	public static final int ParensAround = 0;
	public static final int BeforeQuantityMoney = 1;
	public static final int AfterQuantityMoney = 2;
	public static final int BeforeMoney = 3;
	public static final int AfterMoney = 4;

	public static final int NormalFormat = 1;
	public static final int ShortFormat = 2;

	public static final int WithSeconds = 0;
	public static final int WithoutSeconds = 1;

	/**
		 The Metric system will give you information in mm, while the
		 Imperial system will give you information in inches.
		   		@short    The Metric system will give you information in mm, while the  Imperial system will give you information in inches.
	*/
	public static final int Metric = 0;
	public static final int Imperial = 1;

	/**
		 Constructs a TDELocale with the given catalog name.
		 The constructor looks for an entry Locale/Language in the
		 configuration file.
		 If no config file is specified, it will also look for languages
		 using the environment variables (KDE_LANG, LC_MESSAGES, LC_ALL, LANG),
		 as well as the global configuration file. If TDELocale is not able to use
		 any of the specified languages, the default language (en_US) will be
		 used.
			 If you specify a configuration file, it has to be valid until
		 the TDELocale object is destroyed.
			@param catalog The name of the main language file
			@param config The configuration file to use.
		   		@short    Constructs a TDELocale with the given catalog name.
	*/
	public TDELocale(String catalog, TDEConfig config) {
		newTDELocale(catalog,config);
	}
	private native void newTDELocale(String catalog, TDEConfig config);
	public TDELocale(String catalog) {
		newTDELocale(catalog);
	}
	private native void newTDELocale(String catalog);
	/**
		 Copy constructor.
		   		@short    Copy constructor.
	*/
	public TDELocale(TDELocale rhs) {
		newTDELocale(rhs);
	}
	private native void newTDELocale(TDELocale rhs);
	/**
		 Translates the string into the corresponding string in
		 the national language, if available. If not, returns
		 the string itself.
		 There is a KDE wide message file that contains the most
		 often used phrases, so we can avoid duplicating the
		 translation of these phrases. If a phrase is not found
		 in the catalog given to the constructor, it will search
		 in the system catalog. This makes it possible to override
		 some phrases for your needs.
			 The argument must be an UTF-8 encoded string (If you only use
		 characters that are in US-ASCII you're on the safe side. But
		 for e.g. german umlauts or french accents should be recoded to
		 UTF-8)
			@param index The lookup text and default text, if not found.
		   		@short    Translates the string into the corresponding string in  the national language, if available.
	*/
	public native String translate(String index);
	/**
		 Translates the string into the corresponding string in the
		 national language, if available.
			 The real contents of the string is in the argument fallback,
		 but the meaning of it is coded into the argument index.
		 In some cases you'll need this function, when english is
		 too ambiguous to express it.
			 Most of the times the translators will tell you if it can't
		 be translated as it, but think of cases as "New", where the
		 translations differs depending on what is New.
		 Or simple cases as "Open", that can be used to express something
		 is open or it can be used to express that you want something to
		 open... There are tons of such examples.
			 If translate("Open") is not enough to translate it well, use
		 translate("To Open", "Open") or translate("Is Open", "Open").
		 The english user will see "Open" in both cases, but the translated
		 version may vary. Of course you can also use i18n()
			@param comment the comment. The lookup text is made out of comment + <code>fallback</code>
			@param fallback the default text, if not found
				@return translation

		@short    Translates the string into the corresponding string in the  national language, if available.
	*/
	public native String translate(String comment, String fallback);
	/**
		 Used to get the correct, translated singular or plural of a
		 word.
			@param singular the singular form of the word, for example "file".
			@param plural the plural form of the word. Must contain a "%n" that will
		               be replaced by the number <code>n</code>, for example "%n files"
			@param n the number
				@return the correct singular or plural for the selected language,
         depending on n

		@short    Used to get the correct, translated singular or plural of a  word.
	*/
	public native String translate(String singular, String plural, long n);
	/**
		 Changes the current encoding.
			@param mibEnum The mib of the preferred codec
				@return True on success.

		@short    Changes the current encoding.
	*/
	public native boolean setEncoding(int mibEnum);
	/**
		 Changes the current language. The current language will be left
		 unchanged if failed. It will force a reload of the country specific
		 configuration as well.
			@param language The language code.
				@return True on success.

		@short    Changes the current language.
	*/
	public native boolean setLanguage(String language);
	/**
		 Changes the list of prefed languages for the locale. The first valid
		 language in the list will be used, or the default (en_US) language
		 will be used if non of the specified languages were available.
			@param languages The list of language codes.
				@return True if one of the specified languages were used.

		@short    Changes the list of prefed languages for the locale.
	*/
	public native boolean setLanguage(String[] languages);
	/**
		 Changes the current country. The current country will be left
		 unchanged if failed. It will force a reload of the country specific
		 configuration.
			@param country The ISO 3166 country code.
				@return True on success.

		@short    Changes the current country.
	*/
	public native boolean setCountry(String country);
	/**
		 Returns what a decimal point should look like ("." or "," etc.)
		 according to the current locale or user settings.
				@return The decimal symbol used by locale.

		@short    Returns what a decimal point should look like (".
	*/
	public native String decimalSymbol();
	/**
		 Returns what the thousands separator should look
		 like ("," or "." etc.)
		 according to the current locale or user settings.
				@return The thousands separator used by locale.

		@short    Returns what the thousands separator should look  like ("," or ".
	*/
	public native String thousandsSeparator();
	/**
		 Returns what the symbol denoting currency in the current locale
		 as as defined by user settings should look like.
				@return The default currency symbol used by locale.

		@short    Returns what the symbol denoting currency in the current locale  as as defined by user settings should look like.
	*/
	public native String currencySymbol();
	/**
		 Returns what a decimal point should look like ("." or "," etc.)
		 for monetary values, according to the current locale or user
		 settings.
				@return The monetary decimal symbol used by locale.

		@short    Returns what a decimal point should look like (".
	*/
	public native String monetaryDecimalSymbol();
	/**
		 Returns what a thousands separator for monetary values should
		 look like ("," or " " etc.) according to the current locale or
		 user settings.
				@return The monetary thousands separator used by locale.

		@short    Returns what a thousands separator for monetary values should  look like ("," or " " etc.
	*/
	public native String monetaryThousandsSeparator();
	/**
		 Returns what a positive sign should look like ("+", " ", etc.)
		 according to the current locale or user settings.
				@return The positive sign used by locale.

		@short    Returns what a positive sign should look like ("+", " ", etc.
	*/
	public native String positiveSign();
	/**
		 Returns what a negative sign should look like ("-", etc.)
		 according to the current locale or user settings.
				@return The negative sign used by locale.

		@short    Returns what a negative sign should look like ("-", etc.
	*/
	public native String negativeSign();
	/**
		 The number of fractional digits to include in numeric/monetary
		 values (usually 2).
				@return Default number of fractional digits used by locale.

		@short    The number of fractional digits to include in numeric/monetary  values (usually 2).
	*/
	public native int fracDigits();
	/**
		 If and only if the currency symbol precedes a positive value,
		 this will be true.
				@return Where to print the currency symbol for positive numbers.

		@short    If and only if the currency symbol precedes a positive value,  this will be true.
	*/
	public native boolean positivePrefixCurrencySymbol();
	/**
		 If and only if the currency symbol precedes a negative value,
		 this will be true.
				@return True if the currency symbol precedes negative numbers.

		@short    If and only if the currency symbol precedes a negative value,  this will be true.
	*/
	public native boolean negativePrefixCurrencySymbol();
	/**
		 Returns the position of a positive sign in relation to a
		 monetary value.
				@return Where/how to print the positive sign.

		@short    Returns the position of a positive sign in relation to a  monetary value.
		@see SignPosition
	*/
	public native int positiveMonetarySignPosition();
	/**
		 Denotes where to place a negative sign in relation to a
		 monetary value.
				@return Where/how to print the negative sign.

		@short    Denotes where to place a negative sign in relation to a  monetary value.
		@see SignPosition
	*/
	public native int negativeMonetarySignPosition();
	/**
		 Given a double, converts that to a numeric string containing
		 the localized monetary equivalent.
			 e.g. given 123456, return "$ 123,456.00".
			@param num The number we want to format
			@param currency The currency symbol you want.
			@param digits Number of fractional digits, or -1 for the default
		               value
				@return The number of money as a localized string

		@short    Given a double, converts that to a numeric string containing  the localized monetary equivalent.
		@see #fracDigits
	*/
	public native String formatMoney(double num, String currency, int digits);
	public native String formatMoney(double num, String currency);
	public native String formatMoney(double num);
	/**
		 Given a double, converts that to a numeric string containing
		 the localized numeric equivalent.
			 e.g. given 123456.78F, return "123,456.78" (for some European country).
		 If precision isn't specified, 2 is used.
			 This function is a wrapper that is provided for convenience.
			@param num The number to convert
			@param precision Number of fractional digits used.
				@return The number as a localized string

		@short    Given a double, converts that to a numeric string containing  the localized numeric equivalent.
		@see #formatNumber(const
		@see #boolean
		@see #int)
	*/
	public native String formatNumber(double num, int precision);
	public native String formatNumber(double num);
	/**
		 Given a string representing a number, converts that to a numeric
		 string containing the localized numeric equivalent.
			 e.g. given 123456.78F, return "123,456.78" (for some European country).
			@param numStr The number to convert
			@param round Round  fractional digits.
			@param precision Number of fractional digits used.
				@return The number as a localized string

		@short    Given a string representing a number, converts that to a numeric  string containing the localized numeric equivalent.
	*/
	public native String formatNumber(String numStr, boolean round, int precision);
	/**
		 Given an integer, converts that to a numeric string containing
		 the localized numeric equivalent.
			 e.g. given 123456L, return "123,456" (for some European country).
			@param num The number to convert
				@return The number as a localized string

		@short    Given an integer, converts that to a numeric string containing  the localized numeric equivalent.
	*/
	public native String formatLong(long num);
	/**
		 Use this to determine whether nouns are declined in
		 locale's language. This property should remain
		 read-only (no setter function)
				@return If nouns are declined

		@short    Use this to determine whether nouns are declined in  locale's language.
	*/
	public native boolean nounDeclension();
	/**
		 Returns a string formatted to the current locale's conventions
		 regarding dates.
			@param pDate The date to be formated.
			@param shortFormat True for non text dates.
				@return The date as a string

		@short    Returns a string formatted to the current locale's conventions  regarding dates.
	*/
	public native String formatDate(Calendar pDate, boolean shortFormat);
	public native String formatDate(Calendar pDate);
	/**
		 Use this to determine whether in dates a possessive form of month
		 name is preferred ("of January" rather than "January")
				@return If possessive form should be used

		@short    Use this to determine whether in dates a possessive form of month  name is preferred ("of January" rather than "January")
	*/
	public native boolean dateMonthNamePossessive();
	/**
		 Returns a string formatted to the current locale's conventions
		 regarding times.
			@param pTime The time to be formated.
			@param includeSecs if true, seconds are included in the output,
		        otherwise only hours and minutes are formatted.
			@param isDuration if true, the given time is a duration, not a clock time.
		 This means "am/pm" shouldn't be displayed.
				@return The time as a string

		@short    Returns a string formatted to the current locale's conventions  regarding times.
	*/
	public native String formatTime(Date pTime, boolean includeSecs, boolean isDuration);
	/**
		 Returns a string formatted to the current locale's conventions
		 regarding times.
			@param pTime The time to be formated.
			@param includeSecs if true, seconds are included in the output,
		        otherwise only hours and minutes are formatted.
				@return The time as a string

		@short    Returns a string formatted to the current locale's conventions  regarding times.
	*/
	public native String formatTime(Date pTime, boolean includeSecs);
	public native String formatTime(Date pTime);
	/**
		 Use this to determine if the user wants a 12 hour clock.
				@return If the user wants 12h clock

		@short    Use this to determine if the user wants a 12 hour clock.
	*/
	public native boolean use12Clock();
	/**
		 Use this to determine which day is the first day of the week.
				@return an integer (Monday=1..Sunday=7)

		@short    Use this to determine which day is the first day of the week.
	*/
	public native int weekStartDay();
	/**
		 Returns a pointer to the calendar system object.
				@return the current calendar system instance

		@short    Returns a pointer to the calendar system object.
	*/
	public native KCalendarSystem calendar();
	/**
		 Returns the name of the calendar system that is currently being
		 used by the system.
				@return the name of the calendar system

		@short    Returns the name of the calendar system that is currently being  used by the system.
	*/
	public native String calendarType();
	/**
		 Changes the current calendar system to the calendar specified.
		 Currently "gregorian" and "hijri" are supported. If the calendar
		 system specified is not found, gregorian will be used.
			@param calendarType the name of the calendar type
				@short    Changes the current calendar system to the calendar specified.
	*/
	public native void setCalendar(String calendarType);
	/**
		 Returns a string formated to the current locale's conventions
		 regarding both date and time.
			@param pDateTime The date and time to be formated.
			@param shortFormat using the short date format.
			@param includeSecs using the short date format.
				@return The date and time as a string

		@short    Returns a string formated to the current locale's conventions  regarding both date and time.
	*/
	public native String formatDateTime(Calendar pDateTime, boolean shortFormat, boolean includeSecs);
	public native String formatDateTime(Calendar pDateTime, boolean shortFormat);
	public native String formatDateTime(Calendar pDateTime);
	/**
		 Converts a localized monetary string to a double.
			@param numStr the string we want to convert.
			@param ok the booleanean that is set to false if it's not a number.
		           If <code>ok</code> is 0, it will be ignored
				@return The string converted to a double

		@short    Converts a localized monetary string to a double.
	*/
	public native double readMoney(String numStr, boolean[] ok);
	public native double readMoney(String numStr);
	/**
		 Converts a localized numeric string to a double.
			@param numStr the string we want to convert.
			@param ok the booleanean that is set to false if it's not a number.
		           If <code>ok</code> is 0, it will be ignored
				@return The string converted to a double

		@short    Converts a localized numeric string to a double.
	*/
	public native double readNumber(String numStr, boolean[] ok);
	public native double readNumber(String numStr);
	/**
		 Converts a localized date string to a Calendar.
		 The boolean pointed by ok will be invalid if the date entered was not valid.
			@param str the string we want to convert.
			@param ok the booleanean that is set to false if it's not a valid date.
		           If <code>ok</code> is 0, it will be ignored
				@return The string converted to a TQDate

		@short    Converts a localized date string to a TQDate.
	*/
	public native Calendar readDate(String str, boolean[] ok);
	public native Calendar readDate(String str);
	/**
		 Converts a localized date string to a Calendar, using the specified format.
		 You will usually not want to use this method.
		   		@short    Converts a localized date string to a TQDate, using the specified format.
	*/
	public native Calendar readDate(String intstr, String fmt, boolean[] ok);
	public native Calendar readDate(String intstr, String fmt);
	/**
		 Converts a localized date string to a Calendar.
		 This method is stricter than readDate(str,&ok): it will either accept
		 a date in full format or a date in short format, depending on <code>flags.</code>
			@param str the string we want to convert.
			@param flags whether the date string is to be in full format or in short format.
			@param ok the booleanean that is set to false if it's not a valid date.
		           If <code>ok</code> is 0, it will be ignored
				@return The string converted to a TQDate

		@short    Converts a localized date string to a TQDate.
	*/
	public native Calendar readDate(String str, int flags, boolean[] ok);
	public native Calendar readDate(String str, int flags);
	/**
		 Converts a localized time string to a Date
		 This method will try to parse it with seconds, then without seconds.
		 The boolean pointed to by <code>ok</code> will be set to false if the time entered was
		 not valid.
			@param str the string we want to convert.
			@param ok the booleanean that is set to false if it's not a valid time.
		           If <code>ok</code> is 0, it will be ignored
				@return The string converted to a TQTime

		@short    Converts a localized time string to a TQTime.
	*/
	public native Date readTime(String str, boolean[] ok);
	public native Date readTime(String str);
	/**
		 Converts a localized time string to a Date
		 This method is stricter than readTime(str,&ok): it will either accept
		 a time with seconds or a time without seconds.
		 Use this method when the format is known by the application.
			@param str the string we want to convert.
			@param flags whether the time string is expected to contain seconds or not.
			@param ok the booleanean that is set to false if it's not a valid time.
		           If <code>ok</code> is 0, it will be ignored
				@return The string converted to a TQTime

		@short    Converts a localized time string to a TQTime.
	*/
	public native Date readTime(String str, int flags, boolean[] ok);
	public native Date readTime(String str, int flags);
	/**
		 Returns the language used by this object. The domain AND the
		 library translation must be available in this language.
		 defaultLanguage() is returned by default, if no other available.
				@return The currently used language.

		@short    Returns the language used by this object.
	*/
	public native String language();
	/**
		 Returns the country code of the country where the user lives.
		 defaultCountry() is returned by default, if no other available.
				@return The country code for the user.

		@short    Returns the country code of the country where the user lives.
	*/
	public native String country();
	/**
		 Returns the preferred languages as ISO 639-1 codes. This means
		 that information about country is removed. If the internal language
		 code might be represented by more than one 639-1 code, they will all be
		 listed (but only once).
			 If the selected languages are "nn, nb, pt_BR", you will get:
		 "nn, nb, pt".
				@return List of language codes

		@short    Returns the preferred languages as ISO 639-1 codes.
		@see #languageList
	*/
	public native ArrayList languagesTwoAlpha();
	/**
		 Returns the languages selected by user. The codes returned here is the
		 internal language codes.
				@return List of language codes

		@short    Returns the languages selected by user.
		@see #languagesTwoAlpha
	*/
	public native ArrayList languageList();
	/**
		 Returns the user's preferred encoding.
				@return The name of the preferred encoding

		@short    Returns the user's preferred encoding.
		@see #codecForEncoding
		@see #encodingMib
	*/
	public native String encoding();
	/**
		 Returns the user's preferred encoding.
				@return The Mib of the preferred encoding

		@short    Returns the user's preferred encoding.
		@see #encoding
		@see #codecForEncoding
	*/
	public native int encodingMib();
	/**
		 Returns the user's preferred encoding. Should never be NULL.
				@return The codec for the preferred encoding

		@short    Returns the user's preferred encoding.
		@see #encoding
		@see #encodingMib
	*/
	public native TQTextCodec codecForEncoding();
	/**
		 Returns the file encoding.
				@return The Mib of the file encoding

		@short    Returns the file encoding.
		@see org.trinitydesktop.qt.TQFile#encodeName
		@see org.trinitydesktop.qt.TQFile#decodeName
	*/
	public native int fileEncodingMib();
	/**
		 Changes the current date format.
			 The format of the date is a string which contains variables that will
		 be replaced:

			<li>
			%Y with the century (e.g. "19" for "1984")
			</li>

			<li>
			%y with the lower 2 digits of the year (e.g. "84" for "1984")
			</li>

			<li>
			%n with the month (January="1", December="12")
			</li>

			<li>
			%m with the month with two digits (January="01", December="12")
			</li>

			<li>
			%e with the day of the month (e.g. "1" on the first of march)
			</li>

			<li>
			%d with the day of the month with two digits(e.g. "01" on the first of march)
			</li>

			<li>
			%b with the short form of the month (e.g. "Jan" for January)
			</li>

			<li>
			%B with the long form of the month (e.g. "January")
			</li>

			<li>
			%a with the short form of the weekday (e.g. "Wed" for Wednesday)
			</li>

			<li>
			%A with the long form of the weekday (e.g. "Wednesday" for Wednesday)
			 Everything else in the format string will be taken as is.
			 For example, March 20th 1989 with the format "%y:%m:%d" results
			 in "89:03:20".
			</li>
				@param format The new date format
		   		@short    Changes the current date format.
	*/
	public native void setDateFormat(String format);
	/**
		 Changes the current short date format.
			 The format of the date is a string which contains variables that will
		 be replaced:

			<li>
			%Y with the century (e.g. "19" for "1984")
			</li>

			<li>
			%y with the lower 2 digits of the year (e.g. "84" for "1984")
			</li>

			<li>
			%n with the month (January="1", December="12")
			</li>

			<li>
			%m with the month with two digits (January="01", December="12")
			</li>

			<li>
			%e with the day of the month (e.g. "1" on the first of march)
			</li>

			<li>
			%d with the day of the month with two digits(e.g. "01" on the first of march)
			</li>

			<li>
			%b with the short form of the month (e.g. "Jan" for January)
			</li>

			<li>
			%B with the long form of the month (e.g. "January")
			</li>

			<li>
			%a with the short form of the weekday (e.g. "Wed" for Wednesday)
			</li>

			<li>
			%A with the long form of the weekday (e.g. "Wednesday" for Wednesday)
			 Everything else in the format string will be taken as is.
			 For example, March 20th 1989 with the format "%y:%m:%d" results
			 in "89:03:20".
			</li>
				@param format The new short date format
		   		@short    Changes the current short date format.
	*/
	public native void setDateFormatShort(String format);
	/**
		 Changes the form of month name used in dates.
			@param possessive True if possessive forms should be used
				@short    Changes the form of month name used in dates.
	*/
	public native void setDateMonthNamePossessive(boolean possessive);
	/**
		 Changes the current time format.
			 The format of the time is string a which contains variables that will
		 be replaced:

			<li>
			%H with the hour in 24h format and 2 digits (e.g. 5pm is "17", 5am is "05")
			</li>

			<li>
			%k with the hour in 24h format and one digits (e.g. 5pm is "17", 5am is "5")
			</li>

			<li>
			%I with the hour in 12h format and 2 digits (e.g. 5pm is "05", 5am is "05")
			</li>

			<li>
			%l with the hour in 12h format and one digits (e.g. 5pm is "5", 5am is "5")
			</li>

			<li>
			%M with the minute with 2 digits (e.g. the minute of 07:02:09 is "02")
			</li>

			<li>
			%S with the seconds with 2 digits  (e.g. the minute of 07:02:09 is "09")
			</li>

			<li>
			%p with pm or am (e.g. 17.00 is "pm", 05.00 is "am")
			 Everything else in the format string will be taken as is.
			 For example, 5.23pm with the format "%H:%M" results
			 in "17:23".
			</li>
				@param format The new time format
		   		@short    Changes the current time format.
	*/
	public native void setTimeFormat(String format);
	/**
		 Changes how TDELocale defines the first day in week.
			@param day first day of the week (Monday=1..Sunday=7) as integer
				@short    Changes how TDELocale defines the first day in week.
	*/
	public native void setWeekStartDay(int day);
	/**
		 Returns the currently selected date format.
				@return Current date format.

		@short    Returns the currently selected date format.
		@see #setDateFormat
	*/
	public native String dateFormat();
	/**
		 Returns the currently selected short date format.
				@return Current short date format.

		@short    Returns the currently selected short date format.
		@see #setDateFormatShort
	*/
	public native String dateFormatShort();
	/**
		 Returns the currently selected time format.
				@return Current time format.

		@short    Returns the currently selected time format.
		@see #setTimeFormat
	*/
	public native String timeFormat();
	/**
		 Changes the symbol used to identify the decimal pointer.
			@param symbol The new decimal symbol.
		   		@short    Changes the symbol used to identify the decimal pointer.
	*/
	public native void setDecimalSymbol(String symbol);
	/**
		 Changes the separator used to group digits when formating numbers.
			@param separator The new thousands separator.
		   		@short    Changes the separator used to group digits when formating numbers.
	*/
	public native void setThousandsSeparator(String separator);
	/**
		 Changes the sign used to identify a positive number. Normally this is
		 left blank.
			@param sign Sign used for positive numbers.
		   		@short    Changes the sign used to identify a positive number.
	*/
	public native void setPositiveSign(String sign);
	/**
		 Changes the sign used to identify a negative number.
			@param sign Sign used for negative numbers.
		   		@short    Changes the sign used to identify a negative number.
	*/
	public native void setNegativeSign(String sign);
	/**
		 Changes the sign position used for positive monetary values.
			@param signpos The new sign position
		   		@short    Changes the sign position used for positive monetary values.
	*/
	public native void setPositiveMonetarySignPosition(int signpos);
	/**
		 Changes the sign position used for negative monetary values.
			@param signpos The new sign position
		   		@short    Changes the sign position used for negative monetary values.
	*/
	public native void setNegativeMonetarySignPosition(int signpos);
	/**
		 Changes the position where the currency symbol should be printed for
		 positive monetary values.
			@param prefix True if the currency symbol should be prefixed instead of
		 postfixed
		   		@short    Changes the position where the currency symbol should be printed for  positive monetary values.
	*/
	public native void setPositivePrefixCurrencySymbol(boolean prefix);
	/**
		 Changes the position where the currency symbol should be printed for
		 negative monetary values.
			@param prefix True if the currency symbol should be prefixed instead of
		 postfixed
		   		@short    Changes the position where the currency symbol should be printed for  negative monetary values.
	*/
	public native void setNegativePrefixCurrencySymbol(boolean prefix);
	/**
		 Changes the number of digits used when formating numbers.
			@param digits The default number of digits to use.
		   		@short    Changes the number of digits used when formating numbers.
	*/
	public native void setFracDigits(int digits);
	/**
		 Changes the separator used to group digits when formating monetary values.
			@param separator The new thousands separator.
		   		@short    Changes the separator used to group digits when formating monetary values.
	*/
	public native void setMonetaryThousandsSeparator(String separator);
	/**
		 Changes the symbol used to identify the decimal pointer for monetary
		 values.
			@param symbol The new decimal symbol.
		   		@short    Changes the symbol used to identify the decimal pointer for monetary  values.
	*/
	public native void setMonetaryDecimalSymbol(String symbol);
	/**
		 Changes the current currency symbol.
			@param symbol The new currency symbol
		   		@short    Changes the current currency symbol.
	*/
	public native void setCurrencySymbol(String symbol);
	/**
		 Returns the preferred page size for printing.
				@return The preferred page size, cast it to TQPrinter.PageSize

		@short    Returns the preferred page size for printing.
	*/
	public native int pageSize();
	/**
		 Changes the preferred page size when printing.
			@param paperFormat the new preferred page size in the format TQPrinter.PageSize
		   		@short    Changes the preferred page size when printing.
	*/
	public native void setPageSize(int paperFormat);
	/**
		 Returns which measuring system we use.
				@return The preferred measuring system

		@short    Returns which measuring system we use.
	*/
	public native int measureSystem();
	/**
		 Changes the preferred measuring system.
				@return value The preferred measuring system

		@short    Changes the preferred measuring system.
	*/
	public native void setMeasureSystem(int value);
	/**
		 Adds another catalog to search for translation lookup.
		 This function is useful for extern libraries and/or code,
		 that provide there own messages.
			 If the catalog does not exist for the chosen language,
		 it will be ignored and en_US will be used.
			@param catalog The catalog to add.
		   		@short    Adds another catalog to search for translation lookup.
	*/
	public native void insertCatalogue(String catalog);
	/**
		 Removes a catalog for translation lookup.
			@param catalog The catalog to remove.
				@short    Removes a catalog for translation lookup.
		@see #insertCatalogue
	*/
	public native void removeCatalogue(String catalog);
	/**
		 Sets the active catalog for translation lookup.
			@param catalog The catalog to activate.
		   		@short    Sets the active catalog for translation lookup.
	*/
	public native void setActiveCatalogue(String catalog);
	/**
		 Translates a message as a TQTranslator is supposed to.
		 The parameters are similar to i18n(), but the result
		 value has other semantics (it can be null)
				@short    Translates a message as a TQTranslator is supposed to.
	*/
	public native String translateQt(String context, String sourceText, String message);
	/**
		 Returns list of all known ISO 639-1 codes.
				@return a list of all language codes

		@short    Returns list of all known ISO 639-1 codes.
	*/
	public native ArrayList allLanguagesTwoAlpha();
	/**
		 Convert a ISO 639-1 code to a human readable form.
			@param code the language ISO 639-1 code
				@return the human readable form

		@short    Convert a ISO 639-1 code to a human readable form.
	*/
	public native String twoAlphaToLanguageName(String code);
	/**
		 Returns list of all known country codes.
				@return a list of all country codes

		@short    Returns list of all known country codes.
	*/
	public native ArrayList allCountriesTwoAlpha();
	/**
		 Convert a country code to a human readable form.
			@param code the country code
				@return the human readable form of the country name

		@short    Convert a country code to a human readable form.
	*/
	public native String twoAlphaToCountryName(String code);
	/**
		 Returns the parts of the parameter str understood as language setting
		 the format is language_COUNTRY.charset
			@param str The string to split.
			@param language This will be set to the language part of the string.
			@param country This will be set to the country part of the string.
			@param charset This will be set to the charset part of the string.
		   		@short    Returns the parts of the parameter str understood as language setting  the format is language_COUNTRY.
	*/
	public static native void splitLocale(String str, StringBuffer language, StringBuffer country, StringBuffer charset);
	/**
		 Use this as main catalog for all TDELocales, if not the appname
		 will be used. This function is best to be the very first instruction
		 in your program's main function as it only has an effect before the
		 first TDELocale object is created.
			@param catalog Catalogue to override all other main catalogues.
		   		@short    Use this as main catalog for  all  TDELocales, if not the appname  will be used.
	*/
	public static native void setMainCatalogue(String catalog);
	/**
		 Finds localized resource in resourceDir( rtype ) + \<lang> + fname.
			@param fname relative path to find
			@param rtype resource type to use
		   		@short    Finds localized resource in resourceDir( rtype ) + \<lang> + fname.
	*/
	public static native String langLookup(String fname, String rtype);
	public static native String langLookup(String fname);
	/**
		 Returns the name of the internal language.
				@return Name of the default language

		@short    Returns the name of the internal language.
	*/
	public static native String defaultLanguage();
	/**
		 Returns the name of the default country.
				@return Name of the default country

		@short    Returns the name of the default country.
	*/
	public static native String defaultCountry();
	/**
			   		@short
	*/
	public static native String _initLanguage(TDEConfigBase config);
	/**
			 pointer.
		   		@short
	*/
	protected static native void initInstance();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
