#ifdef ENABLE_TRACING
#include <tqtextedit.h>
#include <tqfile.h>
#include <stdio.h>

static TQTextEdit *tracer = NULL;

void TRACER(TQtMsgType, const char *msg)
{
  tracer->append(&msg[*msg == '~' ? 1 : 0]);
  if (msg[0] != '~')
  {
    fprintf(stderr, "%s", msg);
    fprintf(stderr, "\r\n");
  }
}

void INIT_TRACE()
{
  if (tracer) return;     // de javu
  tracer = new TQTextEdit();
  tracer->setTextFormat(TQt::LogText);
  tracer->setMaxLogLines(10000);
  tracer->resize(750, 300);
  qInstallMsgHandler(TRACER);
}

void SHOW_TRACE()
{
  tracer->show();
}

void DUMP_TRACE(const char *f)
{
  TQFile file(f); // Write the text to a file
  if (file.open(IO_WriteOnly))
  {
    TQTextStream stream(&file);
    stream << tracer->text();
    file.close();
  }
}

#endif // ENABLE_TRACER
