/* toplevel.cpp

  Copyright (C) 1998   Andreas W�st (AndreasWuest@gmx.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  */

#include <tqgroupbox.h>
#include <tqlayout.h>

#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdesimpleconfig.h>
#include <tdestandarddirs.h>
#include <tdeapplication.h>

#include "gamewidget.h"
#include "toplevel.h"
#include "settings.h"
#include "configbox.h"
#include <tdeaction.h>
#include <kstdaction.h>
#include <kstdgameaction.h>
#include <kdebug.h>

extern Options settings;

void AtomTopLevel::createMenu()
{
    TDEAction *act = KStdGameAction::highscores(main, TQ_SLOT(showHighscores()), actionCollection());
    act->setText(i18n("Show &Highscores"));
    KStdGameAction::quit(this, TQ_SLOT(close()), actionCollection());
    KStdGameAction::restart(main, TQ_SLOT(restartLevel()), actionCollection());

    KStdAction::preferences(this, TQ_SLOT(configopts()), actionCollection());

    undoAction = KStdGameAction::undo (main, TQ_SLOT(doUndo()), actionCollection());
    redoAction = KStdGameAction::redo (main, TQ_SLOT(doRedo()), actionCollection());
    undoAction->setEnabled(false);
    redoAction->setEnabled(false);
    connect (main, TQ_SIGNAL (enableRedo(bool)), TQ_SLOT(enableRedo(bool)));
    connect (main, TQ_SIGNAL (enableUndo(bool)), TQ_SLOT(enableUndo(bool)));

    new TDEAction(i18n("Atom Up"), Key_Up, main, TQ_SLOT(moveUp()), actionCollection(), "atom_up");
    new TDEAction(i18n("Atom Down"), Key_Down, main, TQ_SLOT(moveDown()), actionCollection(), "atom_down");
    new TDEAction(i18n("Atom Left"), Key_Left, main, TQ_SLOT(moveLeft()), actionCollection(), "atom_left");
    new TDEAction(i18n("Atom Right"), Key_Right, main, TQ_SLOT(moveRight()), actionCollection(), "atom_right");

    new TDEAction(i18n("Next Atom"), Key_Tab, main, TQ_SLOT(nextAtom()), actionCollection(), "next_atom");
    new TDEAction(i18n("Previous Atom"), SHIFT+Key_Tab, main, TQ_SLOT(previousAtom()), actionCollection(), "prev_atom");
}

void AtomTopLevel::configopts()
{
    (new ConfigBox(this, "Options"))->show();
}

void AtomTopLevel::initConfig()
{
    config = TDEGlobal::config();
}

void AtomTopLevel::saveConfig()
{
    config = TDEGlobal::config();

    if (settings.changed) {
	  config->setGroup("Options");
	  config->writeEntry("Animation Speed", settings.anim_speed);
	  config->setGroup("Colors");
    }
    config->sync();
}


AtomTopLevel::AtomTopLevel()
{
    main = new GameWidget(this, "gamewidget");
    createMenu();
    initConfig();
    setCentralWidget(main);

    setupGUI( TDEMainWindow::Save | Keys | Create );
}

AtomTopLevel::~AtomTopLevel()
{
}

bool AtomTopLevel::queryExit()
{
    saveConfig();
    return true;
}

void AtomTopLevel::enableRedo(bool enable)
{
    redoAction->setEnabled(enable);
}

void AtomTopLevel::enableUndo(bool enable)
{
    undoAction->setEnabled(enable);
}

#include "toplevel.moc"
