#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>

#include "version.h"
#include "mainwin.h"
#include "map_widget.h"

static const char description[] = I18N_NOOP("Galactic Strategy TDE Game");

int
main(int argc, char **argv)
{
    TDEAboutData aboutData( "konquest", I18N_NOOP("Konquest"),
        KONQUEST_VERSION, description, TDEAboutData::License_GPL,
        I18N_NOOP("Copyright (c) 1999-2001, Developers"));
    aboutData.addAuthor("Russ Steffen",0, "rsteffen@bayarea.net");
    TDECmdLineArgs::init( argc, argv, &aboutData );

    TDEApplication a;
    TQApplication::setGlobalMouseTracking( true );
    TDEGlobal::locale()->insertCatalogue("libtdegames");

    if (a.isRestored())
        RESTORE(MainWindow)
    else {
        MainWindow *w = new MainWindow;
        a.setMainWidget(w);
        w->show();
    }
    return a.exec();
}

