//
// KBlackbox
//
// A simple game inspired by an emacs module
//
// File: main.cpp
//
// The main() function
//


#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>

#include "kbbgame.h"
#include "version.h"


static const char description[] = I18N_NOOP("TDE Blackbox Game");

/*
  The program starts here.
*/

int main( int argc, char **argv )
{
  TDEAboutData aboutData( "kblackbox", I18N_NOOP("KBlackBox"),
    KBVERSION, description, TDEAboutData::License_GPL,
    "(c) 1999-2000, Robert Cimrman");
  aboutData.addAuthor("Robert Cimrman",0, "cimrman3@students.zcu.cz");
  TDECmdLineArgs::init( argc, argv, &aboutData );

  TDEApplication a;
  TDEGlobal::locale()->insertCatalogue("libtdegames");

  if (a.isRestored())
      RESTORE(KBBGame)
  else {
      KBBGame *w = new KBBGame;
      a.setMainWidget(w);
      w->show();
  }
  return a.exec();
}
