/*
    This file is part of the TDE games library
    Copyright (C) 2004 Nicolas Hadacek (hadacek@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "kzoommainwindow.h"
#include "kzoommainwindow.moc"

#include <tdeaction.h>
#include <kstdaction.h>
#include <tdemenubar.h>
#include <kcmenumngr.h>

KZoomMainWindow::KZoomMainWindow(uint min, uint max, uint step, const char *name)
  : TDEMainWindow(0, name), _zoomStep(step), _minZoom(min), _maxZoom(max)
{
  installEventFilter(this);
  
  _zoomInAction = KStdAction::zoomIn(this, TQ_SLOT(zoomIn()), actionCollection());
  _zoomOutAction =
    KStdAction::zoomOut(this, TQ_SLOT(zoomOut()), actionCollection());
  _menu =
    KStdAction::showMenubar(this, TQ_SLOT(toggleMenubar()), actionCollection());
}

void KZoomMainWindow::init(const char *popupName)
{
  // zoom
  setZoom(readZoomSetting());

  // menubar
  _menu->setChecked( menubarVisibleSetting() );  
  toggleMenubar();
  
  // context popup
  if (popupName) {
    TQPopupMenu *popup =
      static_cast<TQPopupMenu *>(factory()->container(popupName, this));
    Q_ASSERT(popup);
    if (popup) KContextMenuManager::insert(this, popup);
  }
}

void KZoomMainWindow::addWidget(TQWidget *widget)
{
  widget->adjustSize();
  TQWidget *tlw = widget->topLevelWidget();
  KZoomMainWindow *zm = 
    static_cast<KZoomMainWindow *>(tlw->tqt_cast("KZoomMainWindow"));
  Q_ASSERT(zm);
  zm->_widgets.append(widget);
  connect(widget, TQ_SIGNAL(destroyed()), zm, TQ_SLOT(widgetDestroyed()));
}

void KZoomMainWindow::widgetDestroyed()
{
  _widgets.remove(static_cast<const TQWidget *>(sender()));
}

bool KZoomMainWindow::eventFilter(TQObject *o, TQEvent *e)
{
  if ( e->type()==TQEvent::LayoutHint )
    setFixedSize(minimumSize()); // because K/TQMainWindow
                                 // does not manage fixed central widget
                                 // with hidden menubar...
  return TDEMainWindow::eventFilter(o, e);
}

void KZoomMainWindow::setZoom(uint zoom)
{
  _zoom = zoom;
  writeZoomSetting(_zoom);
  TQPtrListIterator<TQWidget> it(_widgets);
  for (; it.current(); ++it)
    (*it)->adjustSize();; 
  _zoomOutAction->setEnabled( _zoom>_minZoom );
  _zoomInAction->setEnabled( _zoom<_maxZoom );
}

void KZoomMainWindow::zoomIn()
{
  setZoom(_zoom + _zoomStep);
}

void KZoomMainWindow::zoomOut()
{
  Q_ASSERT( _zoom>=_zoomStep );
  setZoom(_zoom - _zoomStep);
}

void KZoomMainWindow::toggleMenubar()
{
  if ( _menu->isChecked() ) menuBar()->show();
  else menuBar()->hide();
}

bool KZoomMainWindow::queryExit()
{
  writeMenubarVisibleSetting(_menu->isChecked());
  return TDEMainWindow::queryExit();
}
