#ifndef WIZARD_H
#define WIZARD_H

#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqvbox.h>
#include <tqvgroupbox.h>
#include <tqpushbutton.h>

#include <knuminput.h>
#include <tdeconfig.h>
#include <kwizard.h>

#include "pline.h"
#include "mp_interface.h"

class ConnectionData;

class MPWizard : public KWizard
{
 TQ_OBJECT
  

 public:
	MPWizard(const MPGameInfo &gi, ConnectionData &cd,
			 TQWidget *parent = 0, const char *name = 0);

	void showPage(TQWidget *page);

 signals:
	void configureKeys(uint);

 protected slots:
	void accept();

 private slots:
	void typeChanged(int t);
	void lineTypeChanged(int);
	void configureKeysSlot();

 private:
	ConnectionData        &cd;
	enum Type { Local, Server, Client };
	Type                   type;
	TQVBox                 *typePage, *localPage;
	WidgetList<PlayerLine> *wl;
	TQLabel                 *lserver;
	TQLineEdit              *eserver;
	KIntNumInput           *eport;
	TQVGroupBox             *net;
//	TQPushButton            *keys;

	void setupTypePage();
	void setupLocalPage(const MPGameInfo &gi);
	TQString name(uint i) const;
};

#endif // WIZARD_H
