// Author: Denis Kozadaev - (c) 2017-2020


#include "mainwindow.h"

#include <tdeactionclasses.h>
#include <tdemenubar.h>

#include <kiconloader.h>


MainWindow::MainWindow(TQWidget* parent, const char* name) : TDEMainWindow(parent, name)
{
    TDEAction* actionQuit = KStdAction::quit(this, TQ_SLOT(close()), 0);
    TDEAction* actionNew  = new TDEAction( "&New Game", "reload", TQt::CTRL + TQt::Key_N, this, TQ_SLOT(newGame()), this, "New Game");

    mMenu = new TDEPopupMenu(this);
    mMenu->insertItem(SmallIcon("images_display"), "Load an image", this, TQ_SLOT(loadImage()), TQt::CTRL + TQt::Key_L);
    mMenu->insertSeparator();

    actionNew->plug(mMenu);
    actionQuit->plug(mMenu);
    menuBar()->insertItem(tr("Menu"), mMenu);

	mBoard = new GameBoard(this);
	setCentralWidget(mBoard);
}

MainWindow::~MainWindow()
{
	delete mBoard;
	delete mMenu;
}

void MainWindow::newGame()
{
	mBoard->newGame();
}

void MainWindow::loadImage()
{
	mBoard->loadImage();
}

#include "mainwindow.moc"
