#include "test.h"
#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

static const char description[] =
    I18N_NOOP("A TDE KPart Application");

static const char version[] = "v0.1";

static TDECmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Image to open" ), 0 },
    TDECmdLineLastOption
};

int main(int argc, char **argv)
{
    TDEAboutData about("kimageviewertest", I18N_NOOP("KImageViewerTest"), version, description, TDEAboutData::License_GPL, "(C) 2001 Matthias Kretz", 0, 0, "kretz@kde.org");
    about.addAuthor( "Matthias Kretz", 0, "kretz@kde.org" );
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions( options );
    TDEApplication app;

    if (app.isRestored())
        RESTORE(KImageViewerTest)
    else
    {
        TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

        if ( args->count() == 0 )
        {
        KImageViewerTest *widget = new KImageViewerTest;
        widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++ )
            {
                KImageViewerTest *widget = new KImageViewerTest;
                widget->show();
                widget->load( args->url( i ) );
            }
        }
        args->clear();
    }

    return app.exec();
}
