/***************************************************************************
    begin                : Fri Feb 27 2004
    copyright            : (C) 2004 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeactioncollection.h>
#include <kdebug.h>

#include "actioncollection.h"

namespace ActionCollection
{
    TDEActionCollection *actions()
    {
        static TDEActionCollection *a =
            new TDEActionCollection(static_cast<TQWidget *>(0), "JuK Action Collection");
        return a;
    }

    TDEAction *action(const char *key)
    {
#ifndef NDEBUG
        TDEAction *a = actions()->action(key);
        if(!a)
            kdWarning(65432) << "TDEAction \"" << key << "\" is not defined yet." << endl;
        return a;
#else
        return actions()->action(key);
#endif
    }
}
