/***************************************************************************
    begin                : Fri Sep 13 2002
    copyright            : (C) 2002 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdefiledialog.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdeio/netaccess.h>

#include "mediafiles.h"

#include <taglib/tag.h>
#if (TAGLIB_MAJOR_VERSION>1) ||  \
   ((TAGLIB_MAJOR_VERSION==1) && (TAGLIB_MINOR_VERSION>=2))
#define TAGLIB_1_2
#endif
#if (TAGLIB_MAJOR_VERSION>1) ||  \
   ((TAGLIB_MAJOR_VERSION==1) && (TAGLIB_MINOR_VERSION>=3))
#define TAGLIB_1_3
#endif

namespace MediaFiles {
    TQStringList mimeTypes();

    static const char mp3Type[]  = "audio/mpeg";
    static const char oggType[]  = "application/ogg";
    static const char flacType[] = "audio/x-flac";
    static const char mpcType[]  = "audio/x-musepack";
    static const char m3uType[]  = "audio/mpegurl";

    static const char vorbisType[]  = "audio/x-vorbis";
    static const char oggflacType[] = "audio/x-oggflac";

    static const char playlistExtension[] = ".m3u";
}

TQStringList MediaFiles::openDialog(TQWidget *parent)
{
    KFileDialog dialog(TQString(), TQString(), parent, "filedialog", true);
    dialog.setOperationMode(KFileDialog::Opening);

    dialog.setCaption(i18n("Open"));
    dialog.setMode(KFile::Files | KFile::LocalOnly);
    // dialog.ops->clearHistory();
    dialog.setMimeFilter(mimeTypes());

    dialog.exec();

    return convertURLsToLocal(dialog.selectedFiles());
}

TQString MediaFiles::savePlaylistDialog(const TQString &playlistName, TQWidget *parent)
{
    TQString fileName = KFileDialog::getSaveFileName(playlistName + playlistExtension,
                                                    TQString("*").append(playlistExtension),
                                                    parent,
                                                    i18n("Playlists"));
    if(!fileName.isEmpty() && !fileName.endsWith(playlistExtension))
       fileName.append(playlistExtension);

    return fileName;
}

bool MediaFiles::isMediaFile(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, true);

    return result->is(mp3Type) || result->is(oggType) || result->is(flacType)
#ifdef TAGLIB_1_3
                               || result->is(mpcType)
#endif
    ;
}

bool MediaFiles::isPlaylistFile(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, true);
    return result->is(m3uType);
}

bool MediaFiles::isMP3(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, true);
    return result->is(mp3Type);
}

bool MediaFiles::isOgg(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, true);
    return result->is(oggType);
}

bool MediaFiles::isFLAC(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, true);
    return result->is(flacType);
}

bool MediaFiles::isMPC(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, true);
    return result->is(mpcType);
}

bool MediaFiles::isVorbis(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, false);
    return result->is(vorbisType);
}

bool MediaFiles::isOggFLAC(const TQString &fileName)
{
    KMimeType::Ptr result = KMimeType::findByPath(fileName, 0, false);
    return result->is(oggflacType);
}

TQStringList MediaFiles::mimeTypes()
{
    TQStringList l;

    l << mp3Type << oggType << flacType << m3uType << vorbisType
#ifdef TAGLIB_1_2
    << oggflacType
#endif
#ifdef TAGLIB_1_3
    << mpcType
#endif
    ;
    return l;
}

TQStringList MediaFiles::convertURLsToLocal(const TQStringList &urlList, TQWidget *w)
{
    TQStringList result;
    KURL localUrl;

    for(TQStringList::ConstIterator it = urlList.constBegin(); it != urlList.constEnd(); ++it) {
	localUrl = TDEIO::NetAccess::mostLocalURL(KURL::fromPathOrURL(*it), w);

	if(!localUrl.isLocalFile())
	    kdDebug(65432) << localUrl << " is not a local file, skipping.\n";
	else
	    result.append(localUrl.path());
    }

    return result;
}
