#include "stereobuttonaction.h"

namespace NoatunStdAction
{

StereoButtonAction::StereoButtonAction(const TQString& text, int accel, TQObject* parent, const char* name )
	: TDEAction(text, accel, parent, name)
{}

StereoButtonAction::StereoButtonAction(const TQString& text, int accel, const TQObject* receiver, const char* slot, TQObject* parent, const char* name )
	: TDEAction(text, accel, receiver, slot, parent, name)
{}

StereoButtonAction::StereoButtonAction(const TQString& text, const TQIconSet& pix, int accel, TQObject* parent, const char* name )
	: TDEAction(text, pix, accel, parent, name)
{}

StereoButtonAction::StereoButtonAction(const TQString& text, const TQString& pix, int accel, TQObject* parent, const char* name )
	: TDEAction(text, pix, accel, parent, name)
{}

StereoButtonAction::StereoButtonAction(const TQString& text, const TQIconSet& pix, int accel, const TQObject* receiver, const char* slot, TQObject* parent, const char* name )
	: TDEAction(text, pix, accel, receiver, slot, parent, name)
{}

StereoButtonAction::StereoButtonAction(const TQString& text, const TQString& pix, int accel, const TQObject* receiver, const char* slot, TQObject* parent, const char* name )
	: TDEAction(text, pix, accel, receiver, slot, parent, name)
{}

void StereoButtonAction::disable(void)
{
	setEnabled(false);
}

void StereoButtonAction::enable(void)
{
	setEnabled(true);
}

void StereoButtonAction::toggleEnabled(void)
{
	setEnabled(!isEnabled());
}

}

#include "stereobuttonaction.moc"
