/*
  balanceslider for winamp skins
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <waBalanceSlider.h>


WaBalanceSlider::WaBalanceSlider() : WaWidget(_WA_MAPPING_BALANCE_BAR)
{
}


WaBalanceSlider::~WaBalanceSlider()
{
}


void WaBalanceSlider::buildGui()
{
    ws = new WaSlider(_WA_MAPPING_BALANCE_BAR,
		      _WA_MAPPING_BALANCE_SLIDER, true);

    ws->setRange(-100, 100);


    ws->setPixmapSliderButtonUp(_WA_SKIN_BALANCE_SLIDER_NORM);
    ws->setPixmapSliderButtonDown(_WA_SKIN_BALANCE_SLIDER_PRES);
    ws->setPixmapSliderBar(_WA_SKIN_BALANCE_BAR);

    ws->setValue(0);

    connect(ws, TQ_SIGNAL(valueChanged(int)), this,
	    TQ_SIGNAL(balanceSetValue(int)));
    connect(ws, TQ_SIGNAL(sliderPressed()), TQ_SIGNAL(sliderPressed()));
    connect(ws, TQ_SIGNAL(sliderReleased()), TQ_SIGNAL(sliderReleased()));
}


void WaBalanceSlider::setBalanceValue(int val)
{
    int currVal = ws->value();
    if (currVal != val) {
	ws->setValue(val);
    }
}

#include "waBalanceSlider.moc"
