/*
    This file is part of libtdepim.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <tqlayout.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <tdelocale.h>

#include "kdateedit.h"

#include "testdateedit.h"

DateEdit::DateEdit( TQWidget *parent, const char *name )
  : TQWidget( parent, name )
{
  TQVBoxLayout *layout = new TQVBoxLayout( this );
  
  KDateEdit *edit = new KDateEdit( this );
  layout->addWidget( edit );

  connect( edit, TQ_SIGNAL( dateChanged( const TQDate& ) ),
           this, TQ_SLOT( dateChanged( const TQDate& ) ) );
}

void DateEdit::dateChanged( const TQDate &date )
{
  if ( date.isValid() )
    tqDebug( "%s", date.toString().latin1() );
  else
    tqDebug( "invalid date entered" );
}

int main(int argc,char **argv)
{
  TDEAboutData aboutData( "testdateedit", "Test KDateEdit", "0.1" );
  TDECmdLineArgs::init( argc, argv, &aboutData );

  TDEApplication app;

  DateEdit dateEdit;
  app.setMainWidget( &dateEdit );
  dateEdit.show();

  app.exec();
}

#include "testdateedit.moc"
