/*
 *  admain.cpp  -  kalarmd main program
 *  Program:  KAlarm's alarm daemon (kalarmd)
 *  Copyright (c) 2001,2004,2005 by David Jarvie <software@astrojar.org.uk>
 *  Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>
 *  Copyright (c) 1997-1999 Preston Brown <pbrown@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kalarmd.h"

#include <stdlib.h>

#include <tdelocale.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdestartupinfo.h>

#include "adapp.h"

static const TDECmdLineOptions options[] =
{
	{ "autostart", "", 0 },
	TDECmdLineLastOption
};

int main(int argc, char** argv)
{
	TDEAboutData aboutData(DAEMON_APP_NAME, I18N_NOOP("KAlarm Daemon"),
	                     DAEMON_VERSION, I18N_NOOP("KAlarm Alarm Daemon"), TDEAboutData::License_GPL,
	                     "Copyright 1997-1999 Preston Brown\nCopyright 2000-2001 Cornelius Schumacher\nCopyright 2001,2004-2007 David Jarvie", 0,
	                     "http://www.astrojar.org.uk/kalarm");
	aboutData.addAuthor("David Jarvie", I18N_NOOP("Maintainer"), "software@astrojar.org.uk");
	aboutData.addAuthor("Cornelius Schumacher", I18N_NOOP("Author"), "schumacher@kde.org");
	aboutData.addAuthor("Preston Brown", I18N_NOOP("Original Author"), "pbrown@kde.org");

	TDECmdLineArgs::init(argc, argv, &aboutData);
	TDECmdLineArgs::addCmdLineOptions(options);
	TDEUniqueApplication::addCmdLineOptions();
	TDEStartupInfo::disableAutoAppStartedSending();

	if (!AlarmDaemonApp::start())
		exit(0);
	AlarmDaemonApp app;
	return app.exec();
}
