/*
    This file is part of KOrganizer.

    Copyright (c) 2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef INCIDENCECHANGER_H
#define INCIDENCECHANGER_H

#include "korganizer/incidencechangerbase.h"

namespace KCal {
  class ResourceCalendar;
}

class IncidenceChanger : public KOrg::IncidenceChangerBase
{
  TQ_OBJECT
  
  public:
    IncidenceChanger( Calendar *cal, TQObject *parent )
      : IncidenceChangerBase( cal, parent ) {}
    ~IncidenceChanger() {}

    bool beginChange( Incidence *incidence,
                      ResourceCalendar *res, const TQString &subRes );

    bool sendGroupwareMessage( Incidence *incidence,
                               KCal::Scheduler::Method method,
                               KOGlobals::HowChanged action,
                               TQWidget *parent );

    bool endChange( Incidence *incidence,
                    ResourceCalendar *res, const TQString &subRes );

    bool addIncidence( Incidence *incidence,
                       ResourceCalendar *res, const TQString &subRes,
                       TQWidget *parent );
    bool addIncidence( Incidence *incidence,
                       ResourceCalendar *res, const TQString &subRes,
                       TQWidget *parent, int dontAskForGroupware );

    bool changeIncidence( Incidence *oldinc, Incidence *newinc,
                          KOGlobals::WhatChanged, TQWidget *parent );
    bool changeIncidence( Incidence *oldinc, Incidence *newinc,
                          KOGlobals::WhatChanged, TQWidget *parent, int dontAskForGroupware );

    bool deleteIncidence( Incidence *incidence, TQWidget *parent );

    bool cutIncidences( const Incidence::List &incidences, TQWidget *parent );
    bool cutIncidence( Incidence *incidence, TQWidget *parent );

    static bool incidencesEqual( Incidence *inc1, Incidence *inc2 );
    static bool assignIncidence( Incidence *inc1, Incidence *inc2 );

  public slots:
    void cancelAttendees( Incidence *incidence );

  protected:
    bool myAttendeeStatusChanged( Incidence *oldInc, Incidence *newInc );

  private:
    class ComparisonVisitor;
    class AssignmentVisitor;
};

#endif
