/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MK_MBOX_PROTO_H
#define MK_MBOX_PROTO_H

#include "tdeio_proto.h"

/*
 * Protocol for mbox
 */
class MBox_Protocol : public TDEIO_Protocol
{
public:
	MBox_Protocol() {}
	virtual ~MBox_Protocol() {}

	virtual TQString protocol( bool ) const { return "mbox"; }
	virtual TQString configName() const { return "mbox"; }

	virtual bool canReadSubjects() const { return true; }
	virtual bool canDeleteMail() const { return false; }
	virtual bool canReadMail() const { return true; }
	virtual bool fullMessage() const { return true; }

	//virtual int fields() const { return no_fields; }
	//virtual int urlFields() const { return mailbox; }
		
	virtual TQString mailboxName() const { return i18n( "File:" ); }
	
	virtual void recheckKURL( KURL &, TDEIO::MetaData & md ) const
		{ md.insert( "onlynew", "" ); md.insert( "savetime", "" ); }
	virtual void readSubjectKURL( KURL &, TDEIO::MetaData & ) const { }
	virtual void deleteMailKURL( KURL &, TDEIO::MetaData & ) const { }
	virtual void readMailKURL( KURL &, TDEIO::MetaData & ) const   { }

	virtual void configFillGroupBoxes( TQStringList* ) const;
	virtual void configFields( TQPtrVector< TQWidget >*, const TQObject*, TQPtrList< AccountInput >* ) const;
	virtual void readEntries( TQMap< TQString, TQString >*, TQMap< TQString, TQString >* ) const;
	virtual void writeEntries( TQMap< TQString, TQString >* ) const;
};

#endif
