echo "Creating $LOCATION_ROOT/${APP_NAME_LC}/${APP_NAME_LC}.cpp...";
cat << EOF > $LOCATION_ROOT/${APP_NAME_LC}/${APP_NAME_LC}.cpp
/*
 * ${APP_NAME_LC}.cpp
 *
 * Copyright (C) 2004 $AUTHOR <$EMAIL>
 */
#include "${APP_NAME_LC}.h"

#include "${APP_NAME_LC}pref.h"

#include <kprinter.h>
#include <tqpainter.h>
#include <tqpaintdevicemetrics.h>

#include <tdeversion.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdemenubar.h>
#include <kstatusbar.h>
#include <tdeaccel.h>
#include <tdeio/netaccess.h>
#include <tdefiledialog.h>
#include <tdeconfig.h>
#include <kurl.h>
#include <kurldrag.h>
#include <kurlrequesterdlg.h>

#include <kedittoolbar.h>

#include <tdestdaccel.h>
#include <tdeaction.h>
#include <kstdaction.h>

${APP_NAME}::${APP_NAME}()
    : TDEMainWindow( 0, "${APP_NAME}" ),
      m_view(new ${APP_NAME}View(this)),
      m_printer(0)
{
    // accept dnd
    setAcceptDrops(true);

    // tell the TDEMainWindow that this is indeed the main widget
    setCentralWidget(m_view);

    // then, setup our actions
    setupActions();

    // Add typical actions and save size/toolbars/statusbar
    setupGUI();

    // allow the view to change the statusbar and caption
    connect(m_view, TQ_SIGNAL(signalChangeStatusbar(const TQString&)),
            this,   TQ_SLOT(changeStatusbar(const TQString&)));
    connect(m_view, TQ_SIGNAL(signalChangeCaption(const TQString&)),
            this,   TQ_SLOT(changeCaption(const TQString&)));

}

${APP_NAME}::~${APP_NAME}()
{
    delete m_printer;
}

void ${APP_NAME}::load(const KURL& url)
{
    TQString target;
    // the below code is what you should normally do.  in this
    // example case, we want the url to our own.  you probably
    // want to use this code instead for your app

    #if 0
    // download the contents
    if (TDEIO::NetAccess::download(url, target))
    {
        // set our caption
        setCaption(url.prettyURL());

        // load in the file (target is always local)
        loadFile(target);

        // and remove the temp file
        TDEIO::NetAccess::removeTempFile(target);
    }
    #endif

    setCaption(url.prettyURL());
    m_view->openURL(url);
}

void ${APP_NAME}::setupActions()
{
    KStdAction::openNew(this, TQ_SLOT(fileNew()), actionCollection());
    KStdAction::open(this, TQ_SLOT(fileOpen()), actionCollection());
    KStdAction::save(this, TQ_SLOT(fileSave()), actionCollection());
    KStdAction::saveAs(this, TQ_SLOT(fileSaveAs()), actionCollection());
    KStdAction::print(this, TQ_SLOT(filePrint()), actionCollection());
    KStdAction::quit(tdeApp, TQ_SLOT(quit()), actionCollection());

    KStdAction::preferences(this, TQ_SLOT(optionsPreferences()), actionCollection());

    // this doesn't do anything useful.  it's just here to illustrate
    // how to insert a custom menu and menu item
    TDEAction *custom = new TDEAction(i18n("Cus&tom Menuitem"), 0,
                                  this, TQ_SLOT(optionsPreferences()),
                                  actionCollection(), "custom_action");
}

void ${APP_NAME}::saveProperties(TDEConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored

    if (!m_view->currentURL().isNull()) {
#if KDE_IS_VERSION(3,1,3)
        config->writePathEntry("lastURL", m_view->currentURL());
#else
        config->writeEntry("lastURL", m_view->currentURL());
#endif
    }
}

void ${APP_NAME}::readProperties(TDEConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'

    TQString url = config->readPathEntry("lastURL");

    if (!url.isEmpty())
        m_view->openURL(KURL::fromPathOrURL(url));
}

void ${APP_NAME}::dragEnterEvent(TQDragEnterEvent *event)
{
    // accept uri drops only
    event->accept(KURLDrag::canDecode(event));
}

void ${APP_NAME}::dropEvent(TQDropEvent *event)
{
    // this is a very simplistic implementation of a drop event.  we
    // will only accept a dropped URL.  the TQt dnd code can do *much*
    // much more, so please read the docs there
    KURL::List urls;

    // see if we can decode a URI.. if not, just ignore it
    if (KURLDrag::decode(event, urls) && !urls.isEmpty())
    {
        // okay, we have a URI.. process it
        const KURL &url = urls.first();

        // load in the file
        load(url);
    }
}

void ${APP_NAME}::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

    // create a new window
    (new ${APP_NAME})->show();
}

void ${APP_NAME}::fileOpen()
{
    // this slot is called whenever the File->Open menu is selected,
    // the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
    // button is clicked
    KURL url = KURLRequesterDlg::getURL(TQString(), this, i18n("Open Location") );
    if (!url.isEmpty())
        m_view->openURL(url);
}

void ${APP_NAME}::fileSave()
{
    // this slot is called whenever the File->Save menu is selected,
    // the Save shortcut is pressed (usually CTRL+S) or the Save toolbar
    // button is clicked

    // save the current file
}

void ${APP_NAME}::fileSaveAs()
{
    // this slot is called whenever the File->Save As menu is selected,
    KURL file_url = KFileDialog::getSaveURL();
    if (!file_url.isEmpty() && file_url.isValid())
    {
        // save your info, here
    }
}

void ${APP_NAME}::filePrint()
{
    // this slot is called whenever the File->Print menu is selected,
    // the Print shortcut is pressed (usually CTRL+P) or the Print toolbar
    // button is clicked
    if (!m_printer) m_printer = new KPrinter;
    if (m_printer->setup(this))
    {
        // setup the printer.  with TQt, you always "print" to a
        // TQPainter.. whether the output medium is a pixmap, a screen,
        // or paper
        TQPainter p;
        p.begin(m_printer);

        // we let our view do the actual printing
        TQPaintDeviceMetrics metrics(m_printer);
        m_view->print(&p, metrics.height(), metrics.width());

        // and send the result to the printer
        p.end();
    }
}

void ${APP_NAME}::optionsConfigureToolbars()
{
    // use the standard toolbar editor
    saveMainWindowSettings( TDEGlobal::config(), autoSaveGroup() );
    KEditToolbar dlg(actionCollection());
    connect(&dlg, TQ_SIGNAL(newToolbarConfig()), this, TQ_SLOT(newToolbarConfig()));
    dlg.exec();
}

void ${APP_NAME}::newToolbarConfig()
{
    // this slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
    // recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
    createGUI();
    applyMainWindowSettings( TDEGlobal::config(), autoSaveGroup() );
}

void ${APP_NAME}::optionsPreferences()
{
    // popup some sort of preference dialog, here
    ${APP_NAME}Preferences dlg;
    if (dlg.exec())
    {
        // redo your settings
    }
}

void ${APP_NAME}::changeStatusbar(const TQString& text)
{
    // display the text on the statusbar
    statusBar()->message(text);
}

void ${APP_NAME}::changeCaption(const TQString& text)
{
    // display the text on the caption
    setCaption(text);
}

#include "${APP_NAME_LC}.moc"
