#ifndef __ADDCLASS_H__
#define __ADDCLASS_H__


#include <tqstring.h>
#include <tqstringlist.h>


class AddClassInfo
{
public:

  AddClassInfo();

  enum Visibility { PublicClass, ProtectedClass, PrivateClass};
	
  TQString className;
  TQString extends;
  bool    interfaceOpt, abstractOpt, finalOpt;
  TQString projectDir, sourceDir;
  Visibility visibility;
  TQStringList implements;
  bool    createConstructor, createMain;
  TQString documentation;
  TQString license;

  TQString adaFileName() const;

};


class AddClass
{
public:

  AddClass();

  void setInfo(const AddClassInfo &info);
  AddClassInfo &info();

  void setBaseClasses(const TQStringList &classes);
  bool showDialog();

  bool generate();

	
private:

  AddClassInfo m_info;
  TQStringList  m_baseClasses;

};


#endif
