/***************************************************************************
    copyright            : (C) 2007 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_GCSTARPLUGINFETCHER_H
#define TELLICO_GCSTARPLUGINFETCHER_H

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <tqintdict.h>

class TQLabel;
class TDEProcess;

namespace Tellico {
  namespace GUI {
    class ComboBox;
    class CollectionTypeCombo;
  }
  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class GCstarPluginFetcher : public Fetcher {
TQ_OBJECT
  

public:

  GCstarPluginFetcher(TQObject* parent, const char* name=0);
  /**
   */
  virtual ~GCstarPluginFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual bool canSearch(FetchKey k) const { return k == Title; }

  virtual void search(FetchKey key, const TQString& value);
  virtual void updateEntry(Data::EntryPtr entry);
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return GCstarPlugin; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);
  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  class ConfigWidget;
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEProcess* proc, char* buffer, int len);
  void slotError(TDEProcess* proc, char* buffer, int len);
  void slotProcessExited(TDEProcess* proc);

private:
  // map Author, Name, Lang, etc...
  typedef TQMap<TQString, TQVariant> PluginInfo;
  typedef TQValueList<PluginInfo> PluginList;
  // map collection type to all available plugins
  typedef TQMap<int, PluginList> PluginMap;
  static PluginMap pluginMap;
  static PluginList plugins(int collType);
  // we need to keep track if we've searched for plugins yet and by what method
  enum PluginParse {NotYet, Old, New};
  static PluginParse pluginParse;
  static void readPluginsNew(int collType, const TQString& exe);
  static void readPluginsOld(int collType, const TQString& exe);
  static TQString gcstarType(int collType);

  bool m_started;
  int m_collType;
  TQString m_plugin;
  TDEProcess* m_process;
  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries; // map from search result id to entry
  TQStringList m_errors;
};

class GCstarPluginFetcher::ConfigWidget : public Fetch::ConfigWidget {
TQ_OBJECT
  

public:
  ConfigWidget(TQWidget* parent, const GCstarPluginFetcher* fetcher = 0);
  ~ConfigWidget();

  virtual void saveConfig(TDEConfigGroup& config);
  virtual TQString preferredName() const;

private slots:
  void slotTypeChanged();
  void slotPluginChanged();

private:
  void showEvent(TQShowEvent* event);

  bool m_needPluginList;
  TQString m_originalPluginName;
  GUI::CollectionTypeCombo* m_collCombo;
  GUI::ComboBox* m_pluginCombo;
  TQLabel* m_authorLabel;
  TQLabel* m_langLabel;
};

  } // end namespace
} // end namespace

#endif
