/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef FETCHDIALOG_H
#define FETCHDIALOG_H

#include "datavectors.h"

#include <kdialogbase.h>

#include <tqguardedptr.h>

namespace Tellico {
  class EntryView;
  namespace Fetch {
    class Fetcher;
    class SearchResult;
  }
  namespace GUI {
    class ComboBox;
    class ListView;
  }
}

namespace barcodeRecognition {
  class barcodeRecognitionThread;
}

class KComboBox;
class KLineEdit;
class KPushButton;
class KStatusBar;
class KTextEdit;
class TQProgressBar;
class TQTimer;
class TQCheckBox;


namespace Tellico {

/**
 * @author Robby Stephenson
 */
class FetchDialog : public KDialogBase {
TQ_OBJECT
  

public:
  /**
   * Constructor
   */
  FetchDialog(TQWidget* parent, const char* name = 0);
  ~FetchDialog();

public slots:
  void slotResetCollection();

protected:
  bool eventFilter(TQObject* obj, TQEvent* ev);

private slots:
  void slotSearchClicked();
  void slotClearClicked();
  void slotAddEntry();
  void slotMoreClicked();
  void slotShowEntry();
  void slotMoveProgress();

  void slotStatus(const TQString& status);
  void slotUpdateStatus();

  void slotFetchDone(bool checkISBN = true);
  void slotResultFound(Tellico::Fetch::SearchResult* result);
  void slotKeyChanged(int);
  void slotSourceChanged(const TQString& source);
  void slotMultipleISBN(bool toggle);
  void slotEditMultipleISBN();
  void slotInit();
  void slotLoadISBNList();
  void slotUPC2ISBN();

  void slotBarcodeRecognized(TQString);
  void slotBarcodeGotImage(TQImage&);
private:
  void startProgress();
  void stopProgress();
  void setStatus(const TQString& text);
  void adjustColumnWidth();

  void customEvent( TQCustomEvent *e );

  class SearchResultItem;

  KComboBox* m_sourceCombo;
  GUI::ComboBox* m_keyCombo;
  KLineEdit* m_valueLineEdit;
  KPushButton* m_searchButton;
  TQCheckBox* m_multipleISBN;
  KPushButton* m_editISBN;
  GUI::ListView* m_listView;
  EntryView* m_entryView;
  KPushButton* m_addButton;
  KPushButton* m_moreButton;
  KStatusBar* m_statusBar;
  TQProgressBar* m_progress;
  TQTimer* m_timer;
  TQGuardedPtr<KTextEdit> m_isbnTextEdit;
  TQLabel *m_barcodePreview;

  bool m_started;
  int m_resultCount;
  TQString m_oldSearch;
  TQStringList m_isbnList;
  TQStringList m_statusMessages;
  TQMap<int, Data::EntryPtr> m_entries;
  TQPtrList<Fetch::SearchResult> m_results;
  int m_collType;

  barcodeRecognition::barcodeRecognitionThread *m_barcodeRecognitionThread;
};

} //end namespace

#endif
