/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERDIALOG_H
#define FILTERDIALOG_H

// kwidgetlister is copied from tdepim/libtdenetwork cvs
#include "gui/kwidgetlister.h"
#include "filter.h"
#include "datavectors.h"

#include <kdialogbase.h>

#include <tqhbox.h>
#include <tqstring.h>
#include <tqstringlist.h>

class KComboBox;
class KLineEdit;
class KPushButton;

class TQRadioButton;
class TQDialog;

namespace Tellico {
  class FilterDialog;

/**
 * A widget to edit a single FilterRule.
 * It consists of a read-only @ref KComboBox for the field,
 * a read-only @ref KComboBox for the function and
 * a @ref KLineEdit for the content or the pattern (in case of regexps).
 *
 * This class borrows heavily from KMSearchRule in kmail by Marc Mutz
 *
 * @author Robby Stephenson
 */
class FilterRuleWidget : public TQHBox {
TQ_OBJECT
  

public:
  /**
   * Constructor. You give a @ref FilterRule as parameter, which will
   * be used to initialize the widget.
   */
  FilterRuleWidget(FilterRule* rule, TQWidget* parent, const char* name=0);

  /**
   * Set the rule. The rule is accepted regardless of the return
   * value of @ref FilterRule::isEmpty. This widget makes a shallow
   * copy of @p rule and operates directly on it. If @p rule is
   * 0, the widget resets itself, takes user input, but does essentially
   * nothing. If you pass 0, you should probably disable it.
   */
  void setRule(const FilterRule* rule);
  /**
   * Return a reference to the currently worked-on @ref FilterRule.
   */
  FilterRule* rule() const;
  /**
   * Resets the rule currently worked on and updates the widget accordingly.
   */
  void reset();

signals:
  void signalModified();

public slots:
  void setFocus();

protected slots:
  void slotEditRegExp();
  void slotRuleFieldChanged(int which);
  void slotRuleFunctionChanged(int which);

private:
  void initLists();
  void initWidget();

  KComboBox* m_ruleField;
  KComboBox* m_ruleFunc;
  KLineEdit* m_ruleValue;
  KPushButton* m_editRegExp;
  TQDialog* m_editRegExpDialog;
  TQStringList m_ruleFieldList;
  TQStringList m_ruleFuncList;
};

class FilterRuleWidgetLister : public KWidgetLister {
TQ_OBJECT
  

public:
  FilterRuleWidgetLister(TQWidget* parent, const char* name=0);

  const TQPtrList<TQWidget>& widgetList() const;
  void setFilter(Filter::Ptr filter);

public slots:
  void reset();
  virtual void setFocus();

signals:
  void signalModified();

protected:
  virtual void clearWidget(TQWidget* widget);
  virtual TQWidget* createWidget(TQWidget* parent);
};

/**
 * @author Robby Stephenson
 */
class FilterDialog : public KDialogBase {
TQ_OBJECT
  

public:
  enum Mode {
    CreateFilter,
    ModifyFilter
  };

  /**
   * The constructor sets up the dialog.
   *
   * @param parent A pointer to the parent widget
   * @param name The widget name
   */
  FilterDialog(Mode mode, TQWidget* parent, const char* name=0);

  FilterPtr currentFilter();
  void setFilter(FilterPtr filter);

public slots:
  void slotClear();

protected slots:
  virtual void slotOk();
  virtual void slotApply();
  void slotShrink();
  void slotFilterChanged();
  void slotSaveFilter();

signals:
  void signalUpdateFilter(Tellico::FilterPtr);
  void signalCollectionModified();

private:
  void init();

  FilterPtr m_filter;
  const Mode m_mode;
  TQRadioButton* m_matchAll;
  TQRadioButton* m_matchAny;
  FilterRuleWidgetLister* m_ruleLister;
  KLineEdit* m_filterName;
  KPushButton* m_saveFilter;
};

} // end namespace
#endif
